/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.addon.client.renders.blocks;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.addon.blocks.BlockSkyrootChest;
import com.gildedgames.the_aether.addon.tile_entities.TileEntitySkyrootChest;
import com.gildedgames.the_aether.tile_entities.TileEntityChestMimic;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.tileentity.TileEntityChestRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class SkyrootChestRenderer
extends TileEntityChestRenderer {
    private static final ResourceLocation TEXTURE_NORMAL_DOUBLE = Aether.locate((String)"textures/tile_entities/chest/skyroot_double.png");
    private static final ResourceLocation TEXTURE_TRAPPED_DOUBLE = Aether.locate((String)"textures/tile_entities/chest/skyroot_trapped_double.png");
    private static final ResourceLocation TEXTURE_TRAPPED = Aether.locate((String)"textures/tile_entities/chest/skyroot_trapped.png");
    private static final ResourceLocation TEXTURE_NORMAL = Aether.locate((String)"textures/tile_entities/chest/skyroot_normal.png");
    private final ModelChest simpleChest = new ModelChest();
    private final ModelChest largeChest = new ModelLargeChest();

    public void func_192841_a(TileEntityChest te, double posX, double posY, double posZ, float partialTicks, int destroyStage, float alpha) {
        int meta;
        ResourceLocation TEXTURE_DOUBLE;
        ResourceLocation TEXTURE_SINGLE;
        if (te == null) {
            TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)new TileEntitySkyrootChest(), 0.0, 0.0, 0.0, 0.0f);
            return;
        }
        if (te.func_145980_j() == BlockSkyrootChest.Type.SKYROOT || te instanceof TileEntityChestMimic) {
            TEXTURE_SINGLE = TEXTURE_NORMAL;
            TEXTURE_DOUBLE = TEXTURE_NORMAL_DOUBLE;
        } else if (te.func_145980_j() == BlockSkyrootChest.Type.SKYROOT_TRAPPED) {
            TEXTURE_SINGLE = TEXTURE_TRAPPED;
            TEXTURE_DOUBLE = TEXTURE_TRAPPED_DOUBLE;
        } else {
            throw new IllegalStateException("TileEntitySkyrootChest.getChestType() did not return one of BlockSkyrootChest.Type.SKYROOT, BlockSkyrootChest.Type.SKYROOT_TRAPPED");
        }
        if (!te.func_145830_o()) {
            meta = 0;
        } else {
            Block block = te.func_145838_q();
            meta = te.func_145832_p();
            if (block != null && block instanceof BlockSkyrootChest) {
                ((BlockSkyrootChest)block).func_176455_e(te.func_145831_w(), te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()));
                meta = te.func_145832_p();
            }
            te.func_145979_i();
        }
        if (te.field_145992_i == null && te.field_145991_k == null) {
            float nextLidAngle;
            ModelChest model;
            if (te.field_145990_j == null && te.field_145988_l == null) {
                model = this.simpleChest;
                this.func_147499_a(TEXTURE_SINGLE);
            } else {
                model = this.largeChest;
                this.func_147499_a(TEXTURE_DOUBLE);
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)((float)posX), (float)((float)posY + 1.0f), (float)((float)posZ + 1.0f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            int rotation = 0;
            switch (meta) {
                case 2: {
                    rotation = 180;
                    if (te.field_145990_j == null) break;
                    GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 3: {
                    rotation = 0;
                    break;
                }
                case 4: {
                    rotation = 90;
                    break;
                }
                case 5: {
                    rotation = -90;
                    if (te.field_145988_l == null) break;
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
                }
            }
            GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float lidAngle = te.field_145986_n + (te.field_145989_m - te.field_145986_n) * partialTicks;
            if (te.field_145992_i != null && (nextLidAngle = te.field_145992_i.field_145986_n + (te.field_145992_i.field_145989_m - te.field_145992_i.field_145986_n) * partialTicks) > lidAngle) {
                lidAngle = nextLidAngle;
            }
            if (te.field_145991_k != null && (nextLidAngle = te.field_145991_k.field_145986_n + (te.field_145991_k.field_145989_m - te.field_145991_k.field_145986_n) * partialTicks) > lidAngle) {
                lidAngle = nextLidAngle;
            }
            lidAngle = 1.0f - lidAngle;
            lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
            model.field_78234_a.field_78795_f = -(lidAngle * (float)Math.PI / 2.0f);
            model.func_78231_a();
            GL11.glPopMatrix();
        }
    }
}

