/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.data;

import com.windanesz.ancientspellcraft.data.SpellComponentList;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class Knowledge {
    public static final IStoredVariable<Integer> ANCIENT_KNOWLEDGE = IStoredVariable.StoredVariable.ofInt((String)"ancient_knowledge_total", (Persistence)Persistence.ALWAYS).setSynced();

    public static void init() {
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{ANCIENT_KNOWLEDGE});
    }

    public static void addKnowledge(EntityPlayer player, int amount) {
        WizardData data;
        if (player != null && (data = WizardData.get((EntityPlayer)player)) != null) {
            Integer total = (Integer)data.getVariable(ANCIENT_KNOWLEDGE);
            if (total == null || total < 0) {
                total = 0;
            }
            total = total + amount;
            data.setVariable(ANCIENT_KNOWLEDGE, (Object)total);
        }
    }

    public static int getKnowledge(EntityPlayer player) {
        WizardData data;
        if (player != null && (data = WizardData.get((EntityPlayer)player)) != null) {
            Integer total = (Integer)data.getVariable(ANCIENT_KNOWLEDGE);
            if (total == null || total < 0) {
                total = 0;
            }
            return total;
        }
        return 0;
    }

    @Nullable
    public static Spell getRandomNextSpell(EntityPlayer player, Tier tier) {
        WizardData data;
        if (player != null && (data = WizardData.get((EntityPlayer)player)) != null) {
            List<Spell> list = SpellComponentList.getSpellListByTier(tier);
            Spell current = ASUtils.getRandomListItem(list);
            return current;
        }
        return null;
    }
}

