/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.data;

import com.google.common.collect.Maps;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSpells;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public enum SpellComponentList {
    ANTIMAGIC_FIELD(AncientSpellcraftSpells.antimagic_field, new ItemStack(Items.field_151045_i), new ItemStack(WizardryItems.grand_crystal)),
    ARCANE_AEGIS(AncientSpellcraftSpells.arcane_aegis, new ItemStack(WizardryItems.astral_diamond), new ItemStack(WizardryItems.grand_crystal), new ItemStack(Items.field_151153_ao)),
    ARCANE_AUGMENTATION(AncientSpellcraftSpells.arcane_augmentation, new ItemStack(WizardryItems.grand_crystal), new ItemStack(WizardryItems.blast_upgrade)),
    ARCANE_BEAM(AncientSpellcraftSpells.arcane_beam, new ItemStack(WizardryItems.grand_crystal), new ItemStack(Items.field_151128_bU)),
    ARCANE_MAGNETISM(AncientSpellcraftSpells.arcane_magnetism, new ItemStack(Items.field_151061_bv), new ItemStack(Item.func_150898_a((Block)Blocks.field_150429_aA))),
    ASPECT_HUNTER(AncientSpellcraftSpells.aspect_hunter, new ItemStack((Item)Items.field_151031_f), new ItemStack((Item)Items.field_151024_Q), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185223_F)),
    BLOCKWEAVING(AncientSpellcraftSpells.blockweaving, new ItemStack(WizardryBlocks.crystal_block, 1, 0), new ItemStack(Items.field_151005_D)),
    BULWARK(AncientSpellcraftSpells.bulwark, new ItemStack(WizardryItems.magic_crystal, 1, 5), new ItemStack(Items.field_185159_cQ), new ItemStack(WizardryItems.grand_crystal)),
    CHANNEL_POWER(AncientSpellcraftSpells.channel_power, new ItemStack(WizardryItems.astral_diamond), new ItemStack(WizardryItems.astral_diamond), new ItemStack(WizardryItems.astral_diamond)),
    CONTINUITY_CHANT(AncientSpellcraftSpells.continuity_charm, new ItemStack(WizardryItems.grand_crystal), new ItemStack(WizardryItems.duration_upgrade)),
    DISPEL_LESSER_MAGIC(AncientSpellcraftSpells.dispel_lesser_magic, new ItemStack(Items.field_151069_bo), new ItemStack(WizardryItems.grand_crystal), new ItemStack(WizardryItems.siphon_upgrade)),
    DISPEL_GREATER_MAGIC(AncientSpellcraftSpells.dispel_greater_magic, new ItemStack(Items.field_151069_bo), new ItemStack(WizardryItems.astral_diamond), new ItemStack(WizardryItems.siphon_upgrade)),
    FORCEFEND(AncientSpellcraftSpells.forcefend, new ItemStack(WizardryItems.astral_diamond), new ItemStack(Items.field_151153_ao, 0, 0), new ItemStack(Items.field_185159_cQ)),
    INTENSIFYING_FOCUS(AncientSpellcraftSpells.intensifying_focus, new ItemStack(WizardryItems.grand_crystal), new ItemStack(WizardryItems.attunement_upgrade)),
    MAGELIGHT(AncientSpellcraftSpells.magelight, new ItemStack(Item.func_150898_a((Block)Blocks.field_150426_aN)), new ItemStack(Item.func_150898_a((Block)Blocks.field_150478_aa)), new ItemStack(Items.field_151059_bz)),
    MANA_FLARE(AncientSpellcraftSpells.mana_flare, new ItemStack(WizardryItems.magic_wand), new ItemStack(WizardryItems.grand_crystal)),
    PROJECTILE_WARD(AncientSpellcraftSpells.projectile_ward, new ItemStack((Item)Items.field_151027_R), new ItemStack(Items.field_185159_cQ), new ItemStack(Items.field_151032_g)),
    SILENCING_SIGIL(AncientSpellcraftSpells.silencing_sigil, new ItemStack(Blocks.field_150323_B), new ItemStack(Item.func_150898_a((Block)Blocks.field_150451_bX))),
    SKULL_SENTINEL(AncientSpellcraftSpells.skull_sentinel, new ItemStack(Items.field_151144_bL), new ItemStack(WizardryItems.grand_crystal)),
    WATER_WALKING(AncientSpellcraftSpells.water_walking, new ItemStack(Items.field_151131_as), new ItemStack((Item)Items.field_151175_af), new ItemStack(WizardryItems.grand_crystal)),
    ESSENCE_EXTRACTION(AncientSpellcraftSpells.essence_extraction, new ItemStack(WizardryItems.large_mana_flask), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.receptacle)), new ItemStack(WizardryItems.grand_crystal)),
    CONDUIT(AncientSpellcraftSpells.conduit, new ItemStack(WizardryItems.large_mana_flask), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.receptacle)), new ItemStack(WizardryItems.grand_crystal));

    public static final Map<Spell, SpellComponentList> nameIndex;
    private final Spell spell;
    private final ItemStack[] components;

    public static SpellComponentList lookupBySpell(Spell name) {
        return nameIndex.get(name);
    }

    public static boolean containsSpell(Spell spell) {
        return nameIndex.keySet().contains(spell);
    }

    public static List<Spell> getSpellListByTier(Tier tier) {
        ArrayList<Spell> spells = new ArrayList<Spell>();
        for (Spell spell : nameIndex.keySet()) {
            if (spell.getTier() != tier) continue;
            spells.add(spell);
        }
        return spells;
    }

    private SpellComponentList(Spell spell, ItemStack ... components) {
        this.spell = spell;
        this.components = components;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public ItemStack[] getComponents() {
        return this.components;
    }

    static {
        nameIndex = Maps.newHashMapWithExpectedSize((int)SpellComponentList.values().length);
        for (SpellComponentList spellComponent : SpellComponentList.values()) {
            nameIndex.put(spellComponent.spell, spellComponent);
        }
    }
}

