/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.construct;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSounds;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.ICustomHitbox;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntitySpiritWard
extends EntityMagicConstruct
implements ICustomHitbox {
    private static final double SEARCH_BORDER_SIZE = 4.0;
    private static final float BOUNCINESS = 0.2f;
    private float radius;

    public EntitySpiritWard(World world) {
        super(world);
        this.setRadius(3.0f);
        this.field_70158_ak = true;
        this.field_70145_X = true;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.field_70131_O = 2.0f * radius;
        this.field_70130_N = 2.0f * radius;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - (double)radius, this.field_70163_u - (double)radius, this.field_70161_v - (double)radius, this.field_70165_t + (double)radius, this.field_70163_u + (double)radius, this.field_70161_v + (double)radius));
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean func_70067_L() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return super.func_70046_E();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 50 == 0) {
            this.func_184185_a(AncientSpellcraftSounds.SHADOW_MAGIC_LOOP, 1.0f, 1.0f);
        }
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v).face(EnumFacing.UP).clr(93, 12, 174).collide(false).scale(6.0f).time(10).spawn(this.field_70170_p);
            for (int i = 1; i < 3; ++i) {
                double radius = 3.2;
                float angle = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(this.field_70165_t + radius * (double)MathHelper.func_76134_b((float)angle), this.field_70163_u, this.field_70161_v + radius * (double)MathHelper.func_76126_a((float)angle)).vel(0.0, 0.05, 0.0).time(48 + this.field_70146_Z.nextInt(12)).clr(0, 0, 0).spawn(this.field_70170_p);
            }
        }
        List targets = EntityUtils.getEntitiesWithinRadius((double)((double)this.radius + 4.0), (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (World)this.field_70170_p, Entity.class);
        targets.remove((Object)this);
        targets.removeIf(t -> t instanceof EntityXPOrb);
        targets.removeIf(t -> t instanceof EntityMagicArrow || t instanceof EntityThrowable || t instanceof EntityArrow);
        for (Entity target : targets) {
            double nudgeVelocity;
            boolean flag;
            if (!this.isValidTarget(target) || !EntityUtils.isLiving((Entity)target) || !((EntityLivingBase)target).func_70662_br()) continue;
            Vec3d currentPos = Arrays.stream(GeometryUtils.getVertices((AxisAlignedBB)target.func_174813_aQ())).min(Comparator.comparingDouble(v -> v.func_72438_d(this.func_174791_d()))).orElse(target.func_174791_d());
            double currentDistance = target.func_70032_d((Entity)this);
            Vec3d nextTickPos = currentPos.func_72441_c(target.field_70159_w, target.field_70181_x, target.field_70179_y);
            double nextTickDistance = nextTickPos.func_72438_d(this.func_174791_d());
            if (EntityUtils.isLiving((Entity)target)) {
                flag = nextTickDistance <= (double)this.radius;
            } else {
                boolean bl = flag = currentDistance > (double)this.radius && nextTickDistance <= (double)this.radius || currentDistance < (double)this.radius && nextTickDistance >= (double)this.radius;
            }
            if (!flag) continue;
            Vec3d targetRelativePos = currentPos.func_178788_d(this.func_174791_d());
            double d = nudgeVelocity = this.contains(target) ? -0.1 : 0.1;
            if (EntityUtils.isLiving((Entity)target)) {
                nudgeVelocity = 0.25;
            }
            Vec3d extraVelocity = targetRelativePos.func_72432_b().func_186678_a(nudgeVelocity);
            target.field_70159_w = target.field_70159_w * (double)-0.2f + extraVelocity.field_72450_a;
            target.field_70181_x = target.field_70181_x * (double)-0.2f + extraVelocity.field_72448_b;
            target.field_70179_y = target.field_70179_y * (double)-0.2f + extraVelocity.field_72449_c;
            if (target.field_70122_E && target.field_70181_x < 0.0) {
                target.field_70181_x = 0.1;
            }
            double distanceTowardsCentre = -(targetRelativePos.func_72433_c() - (double)this.radius) - ((double)this.radius - nextTickDistance);
            Vec3d targetNewPos = target.func_174791_d().func_178787_e(targetRelativePos.func_72432_b().func_186678_a(distanceTowardsCentre));
            target.func_70107_b(targetNewPos.field_72450_a, targetNewPos.field_72448_b, targetNewPos.field_72449_c);
            this.field_70170_p.func_184134_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, AncientSpellcraftSounds.SHADOW_MAGIC_CHARGE, WizardrySounds.SPELLS, 0.4f, 1.0f, false);
            if (!this.field_70170_p.field_72995_K) continue;
            Vec3d relativeImpactPos = targetRelativePos.func_72432_b().func_186678_a((double)this.radius);
            float yaw = (float)Math.atan2(relativeImpactPos.field_72450_a, -relativeImpactPos.field_72449_c);
            float pitch = (float)Math.asin(relativeImpactPos.field_72448_b / (double)this.radius);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(this.func_174791_d().func_178787_e(relativeImpactPos)).time(6).face((float)((double)(yaw * 180.0f) / Math.PI), (float)((double)(pitch * 180.0f) / Math.PI)).clr(0, 0, 0).spawn(this.field_70170_p);
            for (int i = 0; i < 12; ++i) {
                float yaw1 = yaw + 0.3f * (this.field_70146_Z.nextFloat() - 0.5f) - 1.5707964f;
                float pitch1 = pitch + 0.3f * (this.field_70146_Z.nextFloat() - 0.5f);
                double r = (double)this.radius + 0.05;
                double x = this.field_70165_t + r * (double)MathHelper.func_76134_b((float)yaw1) * (double)MathHelper.func_76134_b((float)pitch1);
                double y = this.field_70163_u + r * (double)MathHelper.func_76126_a((float)pitch1);
                double z = this.field_70161_v + r * (double)MathHelper.func_76126_a((float)yaw1) * (double)MathHelper.func_76134_b((float)pitch1);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(x, y, z).time(6 + this.field_70146_Z.nextInt(6)).face((float)((double)(yaw1 * 180.0f) / Math.PI) + 90.0f, (float)((double)(pitch1 * 180.0f) / Math.PI)).scale(1.5f).clr(0, 0, 0).spawn(this.field_70170_p);
            }
        }
    }

    public boolean contains(Vec3d vec) {
        return vec.func_72438_d(this.func_174791_d()) < (double)this.radius;
    }

    public boolean contains(AxisAlignedBB box) {
        return Arrays.stream(GeometryUtils.getVertices((AxisAlignedBB)box)).allMatch(this::contains);
    }

    public boolean contains(Entity entity) {
        return this.contains(entity.func_174813_aQ());
    }

    public Vec3d calculateIntercept(Vec3d origin, Vec3d endpoint, float fuzziness) {
        double rsquared;
        double t;
        Vec3d line = endpoint.func_178788_d(origin);
        Vec3d closestPoint = origin.func_178787_e(line.func_186678_a(t = -origin.func_178788_d(this.func_174791_d()).func_72430_b(line) / line.func_189985_c()));
        double dsquared = closestPoint.func_72436_e(this.func_174791_d());
        if (dsquared > (rsquared = Math.pow(this.radius + fuzziness, 2.0))) {
            return null;
        }
        return closestPoint.func_178788_d(line.func_72432_b().func_186678_a((double)MathHelper.func_76133_a((double)(rsquared - dsquared))));
    }

    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeFloat(this.getRadius());
        if (this.getCaster() != null) {
            data.writeInt(this.getCaster().func_145782_y());
        }
    }

    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.setRadius(data.readFloat());
        if (!data.isReadable()) {
            return;
        }
        Entity entity = this.field_70170_p.func_73045_a(data.readInt());
        if (entity instanceof EntityLivingBase) {
            this.setCaster((EntityLivingBase)entity);
        } else {
            Wizardry.logger.warn("Spirit Ward caster with ID in spawn data not found");
        }
    }

    public boolean func_90999_ad() {
        return false;
    }
}

