/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.handler;

import com.windanesz.ancientspellcraft.item.ItemKnowledgeOrb;
import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftPotions;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSpells;
import com.windanesz.ancientspellcraft.spell.TimeKnot;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.event.SpellBindEvent;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.potion.Curse;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public final class ASArtefactHandler {
    public static final IStoredVariable<Integer> COUNTDOWN_KEY = IStoredVariable.StoredVariable.ofInt((String)"artefactEternityCountdown", (Persistence)Persistence.NEVER).withTicker(ASArtefactHandler::update);
    public static final IStoredVariable<Integer> SPELL_ID = IStoredVariable.StoredVariable.ofInt((String)"artefactEternitySpell", (Persistence)Persistence.ALWAYS);

    private ASArtefactHandler() {
    }

    private static int update(EntityPlayer player, Integer countdown) {
        if (countdown == null) {
            return 0;
        }
        if (!player.field_70170_p.field_72995_K) {
            WizardData data = WizardData.get((EntityPlayer)player);
            Integer spellId = (Integer)data.getVariable(SPELL_ID);
            if (spellId == null) {
                return 0;
            }
            Spell spell = Spell.byMetadata((int)spellId);
            if (countdown != 1 || ItemArtefact.findMatchingWandAndCast((EntityPlayer)player, (Spell)spell)) {
                // empty if block
            }
            if (countdown > 0) {
                Integer n = countdown;
                Integer n2 = countdown = Integer.valueOf(countdown - 1);
            }
        }
        return countdown;
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact == AncientSpellcraftItems.amulet_time_knot && player.func_70644_a(AncientSpellcraftPotions.time_knot) && player.func_110143_aJ() - event.getAmount() <= 0.0f) {
                    TimeKnot.loopPlayer(player);
                    player.func_70066_B();
                    if (!player.field_70170_p.field_72995_K) {
                        Iterator iterator = player.func_193076_bZ().values().iterator();
                    }
                }
                if (artefact == AncientSpellcraftItems.charm_cryostasis) {
                    if (!(player.func_110143_aJ() <= 6.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f) || !(player.field_70170_p.field_73012_v.nextFloat() < 0.25f)) continue;
                    AncientSpellcraftSpells.cryostasis.cast(player.field_70170_p, player, player.func_184600_cs(), 0, new SpellModifiers());
                    continue;
                }
                if (artefact == AncientSpellcraftItems.ring_berserker) {
                    if (player.field_70170_p.field_72995_K || !(player.func_110143_aJ() <= 6.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f) || player.func_70644_a(MobEffects.field_76420_g)) continue;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 300));
                    continue;
                }
                if (artefact != AncientSpellcraftItems.amulet_rabbit || player.field_70170_p.field_72995_K || !(player.field_70170_p.field_73012_v.nextFloat() < 0.25f)) continue;
                if (!player.func_70644_a(MobEffects.field_76424_c)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 200));
                }
                if (player.func_70644_a(MobEffects.field_76437_t)) continue;
                player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 1));
            }
        }
    }

    @SubscribeEvent
    public static void onPotionApplicableEvent(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact == AncientSpellcraftItems.amulet_poison_resistance) {
                    if (event.getPotionEffect().func_188419_a() != MobEffects.field_76436_u || !(player.field_70170_p.field_73012_v.nextFloat() < 0.5f)) continue;
                    event.setResult(Event.Result.DENY);
                    continue;
                }
                if (artefact != AncientSpellcraftItems.amulet_curse_ward || !(event.getPotionEffect().func_188419_a() instanceof Curse)) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onPotionExpiryEvent(PotionEvent.PotionExpiryEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                ItemStack pendant;
                Spell spell;
                if (artefact != AncientSpellcraftItems.amulet_pendant_of_eternity || ASArtefactHandler.getArtefactItemStack(player, (ItemArtefact)AncientSpellcraftItems.amulet_pendant_of_eternity) == null || (spell = ASArtefactHandler.getCurrentSpellFromSpellBearingArtefact(AncientSpellcraftItems.amulet_pendant_of_eternity, pendant = ASArtefactHandler.getArtefactItemStack(player, (ItemArtefact)AncientSpellcraftItems.amulet_pendant_of_eternity))) == Spells.none || !(spell instanceof SpellBuff)) continue;
                try {
                    SpellBuff obj = (SpellBuff)spell;
                    Field field = ASUtils.ReflectionUtil.getField(obj.getClass(), "potionSet");
                    ASUtils.ReflectionUtil.makeAccessible(field);
                    Set potionset = (Set)field.get(obj);
                    if (!potionset.contains(event.getPotionEffect().func_188419_a())) continue;
                    WizardData data = WizardData.get((EntityPlayer)player);
                    data.setVariable(COUNTDOWN_KEY, (Object)20);
                    data.setVariable(SPELL_ID, (Object)spell.metadata());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).func_70662_br()) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                EntityLivingBase entity;
                if (artefact != AncientSpellcraftItems.charm_reanimation || event.getEntityLiving().field_70170_p.field_72995_K || !(player.field_70170_p.field_73012_v.nextFloat() < 0.15f) || !((entity = event.getEntityLiving()) instanceof EntitySkeleton) && !(entity instanceof EntityZombie)) continue;
                EntitySkeletonMinion skeletonMinion = new EntitySkeletonMinion(entity.field_70170_p);
                skeletonMinion.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                skeletonMinion.setCaster((EntityLivingBase)player);
                skeletonMinion.setLifetime(600);
                if (entity.func_184592_cb().func_77973_b() instanceof ItemBow || entity.func_184614_ca().func_77973_b() instanceof ItemBow) {
                    skeletonMinion.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                } else {
                    skeletonMinion.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151041_m));
                }
                skeletonMinion.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
                entity.field_70170_p.func_72838_d((Entity)skeletonMinion);
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpactArrowEvent(ProjectileImpactEvent.Arrow event) {
        if (!event.getArrow().field_70170_p.field_72995_K && event.getArrow().field_70250_c != null && event.getArrow().field_70250_c instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getArrow().field_70250_c;
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                EntityLivingBase target;
                if (artefact != AncientSpellcraftItems.ring_poison_arrow || !(player.field_70170_p.field_73012_v.nextFloat() < 0.2f) || event.getRayTraceResult().field_72308_g == null || !(event.getRayTraceResult().field_72308_g instanceof EntityLivingBase) || (target = (EntityLivingBase)event.getRayTraceResult().field_72308_g).func_70644_a(MobEffects.field_76436_u)) continue;
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getCaster();
            SpellModifiers modifiers = event.getModifiers();
            int jewelsSetCount = 0;
            if (ItemNewArtefact.isNewArtefactActive(player, AncientSpellcraftItems.belt_enchanter) && event.getSpell().getType() == SpellType.BUFF) {
                modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) * 1.2f, false);
            }
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                float potency = modifiers.get("potency");
                float cost = modifiers.get("cost");
                if (artefact == AncientSpellcraftItems.charm_mana_orb) {
                    modifiers.set("cost", 0.85f * cost, false);
                } else if (artefact == AncientSpellcraftItems.amulet_mana) {
                    modifiers.set("cost", 0.9f * cost, false);
                } else if (artefact == AncientSpellcraftItems.ring_blast) {
                    modifiers.set("cost", 1.25f * cost, false);
                    event.getModifiers().set(WizardryItems.blast_upgrade, event.getModifiers().get(WizardryItems.blast_upgrade) + 0.25f, true);
                } else if (artefact == AncientSpellcraftItems.ring_range) {
                    modifiers.set("cost", 1.25f * cost, false);
                    event.getModifiers().set(WizardryItems.range_upgrade, event.getModifiers().get(WizardryItems.range_upgrade) + 0.25f, true);
                } else if (artefact == AncientSpellcraftItems.charm_elemental_grimoire) {
                    if (event.getSpell().getElement() == Element.FIRE || event.getSpell().getElement() == Element.ICE || event.getSpell().getElement() == Element.LIGHTNING) {
                        modifiers.set("potency", 0.1f + potency, false);
                    }
                } else if (artefact == AncientSpellcraftItems.charm_earth_orb) {
                    if (event.getSpell().getElement() == Element.EARTH) {
                        modifiers.set("potency", 0.3f + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == AncientSpellcraftItems.charm_healing_orb) {
                    if (event.getSpell().getElement() == Element.HEALING) {
                        modifiers.set("potency", 0.3f + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == AncientSpellcraftItems.charm_lightning_orb) {
                    if (event.getSpell().getElement() == Element.LIGHTNING) {
                        modifiers.set("potency", 0.3f + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == AncientSpellcraftItems.charm_fire_orb) {
                    if (event.getSpell().getElement() == Element.FIRE) {
                        modifiers.set("potency", 0.3f + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == AncientSpellcraftItems.charm_ice_orb) {
                    if (event.getSpell().getElement() == Element.ICE) {
                        modifiers.set("potency", 0.3f + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == AncientSpellcraftItems.charm_necromancy_orb) {
                    if (event.getSpell().getElement() == Element.NECROMANCY) {
                        modifiers.set("potency", 0.3f + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (artefact == AncientSpellcraftItems.charm_sorcery_orb) {
                    if (event.getSpell().getElement() == Element.SORCERY) {
                        modifiers.set("potency", 0.3f + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                }
                if (artefact == AncientSpellcraftItems.ring_power) {
                    ++jewelsSetCount;
                    modifiers.set("potency", 0.05f + potency, false);
                    modifiers.set("cost", 0.05f + cost, false);
                    continue;
                }
                if (artefact == AncientSpellcraftItems.amulet_power) {
                    ++jewelsSetCount;
                    modifiers.set("potency", 0.1f + potency, false);
                    modifiers.set("cost", 0.1f + cost, false);
                    continue;
                }
                if (artefact != AncientSpellcraftItems.charm_power_orb) continue;
                ++jewelsSetCount;
                modifiers.set("potency", 0.2f + potency, false);
                modifiers.set("cost", 0.2f + cost, false);
            }
            if (jewelsSetCount > 1) {
                float potency = modifiers.get("potency");
                float potencyBonus = (float)(jewelsSetCount - 1) * 5.0f / 100.0f;
                modifiers.set("potency", potencyBonus + potency, false);
            }
        }
    }

    @SubscribeEvent
    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        EntityPlayer player;
        if (event.getCaster() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)(player = (EntityPlayer)event.getCaster()), (Item)AncientSpellcraftItems.charm_knowledge_orb)) {
            boolean flag = false;
            if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemWand) {
                if (((ItemWand)player.func_184614_ca().func_77973_b()).tier.level == Tier.MASTER.level) {
                    flag = true;
                }
            } else if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemWand && ((ItemWand)player.func_184592_cb().func_77973_b()).tier.level == Tier.MASTER.level) {
                flag = true;
            }
            if (flag) {
                int progression = (int)((float)event.getSpell().getCost() * event.getModifiers().get("progression"));
                List<ItemStack> wands = ASUtils.getAllHotbarWands(player, Tier.ADVANCED);
                if (wands != null && !wands.isEmpty()) {
                    ItemStack targetWand = ASUtils.getRandomListItem(wands);
                    WandHelper.addProgression((ItemStack)targetWand, (int)progression);
                    ItemStack artefact = ASArtefactHandler.getArtefactItemStack(player, (ItemArtefact)AncientSpellcraftItems.charm_knowledge_orb);
                    if (!((ItemKnowledgeOrb)artefact.func_77973_b()).isSwirlAnimationInProgess(artefact)) {
                        ((ItemKnowledgeOrb)artefact.func_77973_b()).startSwirlAnimation(artefact);
                    }
                    Tier nextTier = Tier.values()[((ItemWand)targetWand.func_77973_b()).tier.ordinal() + 1];
                    int excess = WandHelper.getProgression((ItemStack)targetWand) - nextTier.getProgression();
                    if (excess >= 0 && excess < progression) {
                        player.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.25f, 1.0f);
                        if (!player.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:wand.levelup", new Object[]{targetWand.func_77973_b().func_77653_i(targetWand), nextTier.getNameForTranslationFormatted()}));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onArcaneWorkbenchApplyButtonPressed(SpellBindEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            int centre_slot = 9;
            int upgrade_slot = 10;
            ItemStack centre = event.getContainer().func_75139_a(centre_slot).func_75211_c();
            ItemStack upgrade = event.getContainer().func_75139_a(upgrade_slot).func_75211_c();
            EntityPlayer player = event.getEntityPlayer();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact != AncientSpellcraftItems.charm_wand_upgrade || !(player.field_70170_p.field_73012_v.nextFloat() < 0.2f) || !WandHelper.isWandUpgrade((Item)upgrade.func_77973_b()) || !(centre.func_77973_b() instanceof ItemWand)) continue;
                Item specialUpgrade = upgrade.func_77973_b();
                if (WandHelper.getTotalUpgrades((ItemStack)centre) >= ((ItemWand)centre.func_77973_b()).tier.upgradeLimit || WandHelper.getUpgradeLevel((ItemStack)centre, (Item)specialUpgrade) >= 3) continue;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.tag_has_no_name", new Object[0]), true);
                player.func_191521_c(new ItemStack(specialUpgrade));
            }
        }
    }

    private static ItemStack getArtefactItemStack(EntityPlayer player, ItemArtefact artefact) {
        return ASUtils.getItemStackFromInventoryHotbar(player, (Item)artefact);
    }

    private static Spell getCurrentSpellFromSpellBearingArtefact(Item item, ItemStack stack) {
        return Spell.byMetadata((int)stack.func_77952_i());
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                float i;
                if (artefact != AncientSpellcraftItems.ring_prismarine || !player.func_70027_ad() || (i = player.func_184811_cZ().func_185143_a(AncientSpellcraftItems.ring_prismarine, Minecraft.func_71410_x().func_184121_ak())) != 0.0f) continue;
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 120));
                SpellModifiers modifiers = new SpellModifiers();
                if (!AncientSpellcraftSpells.extinguish.cast(player.field_70170_p, player, EnumHand.MAIN_HAND, 0, modifiers)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.SCROLL, AncientSpellcraftSpells.extinguish, (EntityLivingBase)player, modifiers));
                player.func_184811_cZ().func_185145_a(AncientSpellcraftItems.ring_prismarine, 1200);
            }
            if ((float)player.field_70170_p.func_82737_E() % player.func_110143_aJ() < player.func_110138_aP()) {
                // empty if block
            }
        }
    }

    static {
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{COUNTDOWN_KEY, SPELL_ID});
    }
}

