/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.handler;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftPotions;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSpells;
import com.windanesz.ancientspellcraft.spell.MetaSpellBuff;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public final class MetamagicHandler {
    private MetamagicHandler() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() instanceof EntityPlayer && !(event.getSpell() instanceof MetaSpellBuff)) {
            EntityPlayer player = (EntityPlayer)event.getCaster();
            Map potionEffectMap = player.func_193076_bZ();
            for (Map.Entry entry : potionEffectMap.entrySet()) {
                if (((Potion)entry.getKey()).equals(AncientSpellcraftPotions.arcane_augmentation)) {
                    PotionEffect effect = (PotionEffect)entry.getValue();
                    SpellModifiers modifiers = event.getModifiers();
                    float range = modifiers.get(WizardryItems.range_upgrade);
                    float blast = modifiers.get(WizardryItems.blast_upgrade);
                    int level = effect.func_76458_c() + 1;
                    if (level > 0) {
                        modifiers.set(WizardryItems.range_upgrade, blast + (float)level * 0.25f, true);
                        modifiers.set(WizardryItems.blast_upgrade, range + (float)level * 0.25f, true);
                    }
                    MetamagicHandler.onMetaMagicFinished(player, AncientSpellcraftSpells.arcane_augmentation, AncientSpellcraftPotions.arcane_augmentation);
                    break;
                }
                if (((Potion)entry.getKey()).equals(AncientSpellcraftPotions.intensifying_focus)) {
                    PotionEffect effect = (PotionEffect)entry.getValue();
                    SpellModifiers modifiers = event.getModifiers();
                    float potency = modifiers.get("potency");
                    float range = modifiers.get(WizardryItems.range_upgrade);
                    float blast = modifiers.get(WizardryItems.range_upgrade);
                    int level = effect.func_76458_c() + 1;
                    if (level > 0) {
                        modifiers.set("potency", potency + (float)level * 0.15f, true);
                        modifiers.set(WizardryItems.range_upgrade, blast - (float)level * 0.25f, true);
                        modifiers.set(WizardryItems.blast_upgrade, range - (float)level * 0.25f, true);
                    }
                    MetamagicHandler.setCooldown(player, AncientSpellcraftSpells.intensifying_focus);
                    player.func_184589_d(AncientSpellcraftPotions.intensifying_focus);
                    MetamagicHandler.onMetaMagicFinished(player, AncientSpellcraftSpells.intensifying_focus, AncientSpellcraftPotions.intensifying_focus);
                    break;
                }
                if (!((Potion)entry.getKey()).equals(AncientSpellcraftPotions.continuity_charm)) continue;
                PotionEffect effect = (PotionEffect)entry.getValue();
                SpellModifiers modifiers = event.getModifiers();
                float duration = modifiers.get(WizardryItems.duration_upgrade);
                float cost = modifiers.get("cost");
                int level = effect.func_76458_c() + 1;
                if (level > 0) {
                    modifiers.set(WizardryItems.duration_upgrade, duration + (float)level * 0.25f, true);
                    modifiers.set("cost", cost + (float)level * 0.15f, true);
                }
                MetamagicHandler.onMetaMagicFinished(player, AncientSpellcraftSpells.continuity_charm, AncientSpellcraftPotions.continuity_charm);
                break;
            }
        }
    }

    private static void onMetaMagicFinished(EntityPlayer player, Spell spell, Potion effect) {
        MetamagicHandler.setCooldown(player, spell);
        player.func_184589_d(effect);
    }

    private static void setCooldown(EntityPlayer player, Spell spell) {
        List<ItemStack> wands = ASUtils.getAllHotbarWands(player);
        if (wands != null && !wands.isEmpty()) {
            for (ItemStack wand : wands) {
                int index = 0;
                for (Spell currentSpell : WandHelper.getSpells((ItemStack)wand)) {
                    int[] cooldowns = WandHelper.getCooldowns((ItemStack)wand);
                    if (cooldowns.length == 0) {
                        int count = WandHelper.getSpells((ItemStack)wand).length - 1;
                        cooldowns = new int[count];
                    }
                    if (currentSpell == spell) {
                        int[] maxCooldowns = WandHelper.getMaxCooldowns((ItemStack)wand);
                        if (maxCooldowns.length == 0) {
                            int count = WandHelper.getSpells((ItemStack)wand).length - 1;
                            maxCooldowns = new int[count];
                        }
                        cooldowns[index] = 1200;
                        maxCooldowns[index] = 1200;
                        WandHelper.setCooldowns((ItemStack)wand, (int[])cooldowns);
                        WandHelper.setMaxCooldowns((ItemStack)wand, (int[])maxCooldowns);
                    }
                    ++index;
                }
            }
        }
    }

    public static enum MetaEffect {
        ARCANE_AUGMENTATION(AncientSpellcraftPotions.arcane_augmentation),
        INTENSIFYING_FOCUS(AncientSpellcraftPotions.intensifying_focus);

        private final Potion effect;

        private MetaEffect(Potion effect) {
            this.effect = effect;
        }

        public static MetaEffect fromPotion(Potion potion) {
            for (MetaEffect effect : MetaEffect.values()) {
                if (!effect.effect.equals(potion)) continue;
                return effect;
            }
            throw new IllegalArgumentException("No such metamagic type");
        }

        public Potion getEffect() {
            return this.effect;
        }

        @SideOnly(value=Side.CLIENT)
        public String getDisplayName() {
            return I18n.func_135052_a((String)("spelltype." + this.effect), (Object[])new Object[0]);
        }
    }
}

