/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.integration.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.BaublesCapabilities;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;

public final class ASBaublesIntegration {
    public static final String BAUBLES_MOD_ID = "baubles";
    private static final Map<ItemNewArtefact.AdditionalType, BaubleType> ARTEFACT_TYPE_MAP = new EnumMap<ItemNewArtefact.AdditionalType, BaubleType>(ItemNewArtefact.AdditionalType.class);
    private static boolean baublesLoaded;

    public static void init() {
        baublesLoaded = Loader.isModLoaded((String)BAUBLES_MOD_ID);
        if (!ASBaublesIntegration.enabled()) {
            return;
        }
        ARTEFACT_TYPE_MAP.put(ItemNewArtefact.AdditionalType.BELT, BaubleType.BELT);
        ARTEFACT_TYPE_MAP.put(ItemNewArtefact.AdditionalType.HEAD, BaubleType.HEAD);
    }

    public static boolean enabled() {
        return Settings.generalSettings.baubles_integration && baublesLoaded;
    }

    public static List<ItemNewArtefact> getEquippedArtefacts(EntityPlayer player, ItemNewArtefact.AdditionalType ... types) {
        ArrayList<ItemNewArtefact> artefacts = new ArrayList<ItemNewArtefact>();
        for (ItemNewArtefact.AdditionalType type : types) {
            for (int slot : ARTEFACT_TYPE_MAP.get((Object)type).getValidSlots()) {
                ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
                if (!(stack.func_77973_b() instanceof ItemNewArtefact)) continue;
                artefacts.add((ItemNewArtefact)stack.func_77973_b());
            }
        }
        return artefacts;
    }

    public static final class ArtefactBaubleProvider
    implements ICapabilityProvider {
        private BaubleType type;

        public ArtefactBaubleProvider(ItemNewArtefact.AdditionalType type) {
            this.type = (BaubleType)ARTEFACT_TYPE_MAP.get((Object)type);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? itemStack -> this.type : null);
        }
    }
}

