/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.item.ItemArtefact;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class ItemDailyArtefact
extends ItemASArtefact {
    private static final String LAST_OPEN_TIME_TAG = "last_open_time";

    public ItemDailyArtefact(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        long currentWorldTime = player.field_70170_p.func_82737_E();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(LAST_OPEN_TIME_TAG)) {
            long lastAccess = stack.func_77978_p().func_74763_f(LAST_OPEN_TIME_TAG);
            if (ItemDailyArtefact.isFullDayBetween(lastAccess, currentWorldTime)) {
                this.performAction(player);
                ItemDailyArtefact.setLastOpenTimeCurrent(stack, currentWorldTime);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (!player.field_70170_p.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".empty", new Object[0]), true);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        this.performAction(player);
        ItemDailyArtefact.setLastOpenTimeCurrent(stack, currentWorldTime);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static boolean isFullDayBetween(long startTime, long endTime) {
        long fullDay = 24000L;
        return endTime - startTime >= fullDay;
    }

    public abstract void performAction(EntityPlayer var1);

    public static void setLastOpenTimeCurrent(ItemStack stack, long currentTime) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_74772_a(LAST_OPEN_TIME_TAG, currentTime);
            stack.func_77982_d(nbt);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a(LAST_OPEN_TIME_TAG, currentTime);
            stack.func_77982_d(nbt);
        }
    }
}

