/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElementalOrb
extends ItemASArtefact
implements ISpellCastingItem {
    private boolean enabled = true;
    private String spell;
    private int cooldown;
    private Element element;

    public ItemElementalOrb(EnumRarity rarity, ItemArtefact.Type type, String spell, int cooldown, Element element) {
        super(rarity, type);
        this.spell = spell;
        this.cooldown = cooldown;
        this.element = element;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc", new Object[0]);
        Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc2", this.element.getColour(), new Object[0]);
        Wizardry.proxy.addMultiLineDescription(tooltip, "set.ancientspellcraft:elemental_orbs", new Style().func_150238_a(TextFormatting.GOLD), new Object[0]);
        if (!this.enabled) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:generic.disabled", new Style().func_150238_a(TextFormatting.RED), new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Spell spell = this.getCurrentSpell(stack);
        SpellModifiers modifiers = new SpellModifiers();
        if (this.element == Element.HEALING) {
            float f = modifiers.get("effect_duration");
            modifiers.set("effect_duration", f / 3.0f, true);
        }
        if (this.canCast(stack, spell, player, hand, 0, modifiers)) {
            if (spell.isContinuous) {
                if (!player.func_184587_cr()) {
                    player.func_184598_c(hand);
                    if (WizardData.get((EntityPlayer)player) != null) {
                        WizardData.get((EntityPlayer)player).itemCastingModifiers = modifiers;
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if (this.cast(stack, spell, player, hand, 0, modifiers)) {
                if (this.element == Element.HEALING) {
                    player.func_184589_d(MobEffects.field_76444_x);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 300, 1));
                    spell = Spells.blinding_flash;
                    modifiers = new SpellModifiers();
                    if (this.cast(stack, spell, player, hand, 0, modifiers)) {
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                    }
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase user, int timeLeft) {
        this.finishCasting(stack, user, timeLeft);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase user) {
        this.finishCasting(stack, user, 0);
        return stack;
    }

    private void finishCasting(ItemStack stack, EntityLivingBase user, int timeLeft) {
        if (Spell.byMetadata((int)stack.func_77952_i()).isContinuous) {
            Spell spell = Spell.byMetadata((int)stack.func_77952_i());
            SpellModifiers modifiers = new SpellModifiers();
            int castingTick = stack.func_77988_m() - timeLeft;
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Finish(SpellCastEvent.Source.SCROLL, spell, user, modifiers, castingTick));
            spell.finishCasting(user.field_70170_p, user, Double.NaN, Double.NaN, Double.NaN, null, castingTick, modifiers);
            if (user instanceof EntityPlayer) {
                ((EntityPlayer)user).func_184811_cZ().func_185145_a((Item)this, spell.getCooldown());
            }
        }
    }

    public boolean cast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        World world = caster.field_70170_p;
        if (world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
            return false;
        }
        if (spell.cast(world, caster, hand, castingTick, modifiers)) {
            if (castingTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)caster, modifiers));
            }
            if (!world.field_72995_K) {
                if (!spell.isContinuous && spell.requiresPacket()) {
                    PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), hand, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
                }
                caster.func_184811_cZ().func_185145_a((Item)this, this.cooldown);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Spell getCurrentSpell(ItemStack stack) {
        return Spell.get((String)this.spell);
    }

    public boolean showSpellHUD(EntityPlayer player, ItemStack stack) {
        return false;
    }

    public boolean canCast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        if (castingTick == 0) {
            return !MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)caster, modifiers));
        }
        return !MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)caster, modifiers, castingTick));
    }
}

