/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftTabs;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnchantedNameTag
extends ItemNameTag
implements IWorkbenchItem,
IManaStoringItem {
    public ItemEnchantedNameTag() {
        this.func_77637_a(AncientSpellcraftTabs.ANCIENTSPELLCRAFT);
        this.func_77656_e(300);
        this.field_77777_bU = 1;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return !this.isManaEmpty(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            if (crystals.func_75211_c().func_190916_E() * 100 < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * 100);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / 100.0));
            }
            changed = true;
        }
        return changed;
    }

    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    public boolean canPlace(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        if (this.isManaEmpty(stack)) {
            Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc_empty", new Object[0]);
        } else {
            Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc_filled", new Object[0]);
        }
        if (advanced.func_194127_a()) {
            tooltip.add("\u00a79" + I18n.func_135052_a((String)"item.ebwizardry:wand.mana", (Object[])new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
        }
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND) {
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".right_click", new Object[0]), true);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.try_listbiomes", new Object[0]));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_184614_ca().func_77973_b() instanceof ISpellCastingItem) {
            Spell currSpell = ((ISpellCastingItem)player.func_184614_ca().func_77973_b()).getCurrentSpell(player.func_184614_ca());
            if (currSpell.getUnlocalisedName().equals("ancientspellcraft:will_o_wisp")) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".right_click", new Object[0]), true);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.try_listbiomes", new Object[0]));
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }
}

