/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemArtefact;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEverfullManaFlask
extends ItemASArtefact
implements IManaStoringItem {
    private static final int MANA_CAPACITY = 1400;
    private static final int MANA_REGEN = 3;

    public ItemEverfullManaFlask(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
        this.func_77656_e(1400);
        this.func_185043_a(new ResourceLocation("mana"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return (float)ItemEverfullManaFlask.this.getMana(stack) / 1400.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            ItemStack flask = player.func_184592_cb();
            ItemStack mainhandStack = player.func_184614_ca();
            if (mainhandStack.func_77973_b() instanceof IManaStoringItem) {
                IManaStoringItem manaStoringItem = (IManaStoringItem)mainhandStack.func_77973_b();
                int capacity = this.getManaCapacity(flask);
                int currMana = this.getMana(flask);
                int amount = currMana >= capacity / 10 ? capacity / 10 : currMana;
                int missingMana = manaStoringItem.getManaCapacity(mainhandStack) - manaStoringItem.getMana(mainhandStack);
                if (missingMana < amount) {
                    amount = missingMana;
                }
                manaStoringItem.rechargeMana(mainhandStack, amount);
                this.consumeMana(flask, amount, (EntityLivingBase)player);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)flask);
            }
            if (!player.field_70170_p.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".invalid_use", new Object[0]), true);
                return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
            }
        }
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".invalid_use", new Object[0]), true);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (entity instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)entity), (Item)AncientSpellcraftItems.charm_mana_flask) && !world.field_72995_K && !this.isManaFull(stack) && world.func_82737_E() % 50L == 0L) {
            this.rechargeMana(stack, 3);
        }
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> text, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, text, flagIn);
        text.add("\u00a79" + I18n.func_135052_a((String)"item.ebwizardry:wand.mana", (Object[])new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }
}

