/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.item.IConjuredItem;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemIceShield
extends Item
implements IConjuredItem {
    private EnumRarity rarity = EnumRarity.COMMON;

    public ItemIceShield() {
        this.func_77664_n();
        this.field_77777_bU = 1;
        this.func_77656_e(180);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        this.addAnimationPropertyOverrides();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)("item." + this.getRegistryName() + ".desc1"), (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)("item." + this.getRegistryName() + ".desc2"), (Object[])new Object[0]));
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return true;
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public Item setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxDamageFromNBT(stack, Spells.conjure_sword);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        oldStack = oldStack.func_77946_l();
        oldStack.func_77982_d(null);
        newStack = newStack.func_77946_l();
        newStack.func_77982_d(null);
        return !ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        int damage = stack.func_77952_i();
        if (damage > stack.func_77958_k() || damage < 0) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184592_cb().func_77973_b() instanceof ItemIceShield) {
                ((EntityPlayer)entity).func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            } else {
                entity.func_174820_d(slot, ItemStack.field_190927_a);
            }
            if (world.field_72995_K) {
                world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, entity.field_70165_t, entity.field_70163_u + 0.5, entity.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                for (int i = 0; i < 60; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.ICE, (Random)world.field_73012_v, (double)entity.field_70165_t, (double)(entity.field_70163_u + 0.5), (double)entity.field_70161_v, (double)2.0, (boolean)false).time(35).gravity(true).spawn(world);
                    float brightness = 0.4f + world.field_73012_v.nextFloat() * 0.5f;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC, (Random)world.field_73012_v, (double)entity.field_70165_t, (double)(entity.field_70163_u + 0.5), (double)entity.field_70161_v, (double)2.0, (boolean)false).clr(brightness, brightness + 0.1f, 1.0f).spawn(world);
                }
            }
            if (!world.field_72995_K) {
                int i;
                world.func_184133_a(null, entity.func_180425_c(), WizardrySounds.ENTITY_ICE_CHARGE_SMASH, SoundCategory.PLAYERS, 1.5f, world.field_73012_v.nextFloat() * 0.4f + 0.6f);
                world.func_184133_a(null, entity.func_180425_c(), WizardrySounds.ENTITY_ICE_CHARGE_ICE, SoundCategory.PLAYERS, 1.2f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
                double radius = (double)Spells.ice_charge.getProperty("effect_radius").floatValue() * 1.5;
                List targets = EntityUtils.getLivingWithinRadius((double)radius, (double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (World)entity.field_70170_p);
                for (EntityLivingBase target : targets) {
                    if (target == entity || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)target)) continue;
                    target.func_70690_d(new PotionEffect(WizardryPotions.frost, Spells.ice_charge.getProperty("splash_effect_duration").intValue(), Spells.ice_charge.getProperty("splash_effect_strength").intValue()));
                }
                for (i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        double dist;
                        BlockPos pos = new BlockPos(entity.field_70165_t + (double)i, entity.field_70163_u, entity.field_70161_v + (double)j);
                        Integer y = BlockUtils.getNearestSurface((World)world, (BlockPos)pos, (EnumFacing)EnumFacing.UP, (int)7, (boolean)true, (BlockUtils.SurfaceCriteria)BlockUtils.SurfaceCriteria.SOLID_LIQUID_TO_AIR);
                        if (y == null || world.field_73012_v.nextInt((int)(dist = entity.func_70011_f((double)(pos = new BlockPos(pos.func_177958_n(), y.intValue(), pos.func_177952_p())).func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) * 2 + 1) >= 1 || !(dist < 2.0)) continue;
                        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j) {
                            world.func_175656_a(pos.func_177977_b(), Blocks.field_150432_aD.func_176223_P());
                            continue;
                        }
                        world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P());
                    }
                }
                if (entity instanceof EntityLivingBase) {
                    for (i = 0; i < 20; ++i) {
                        double dx = world.field_73012_v.nextDouble() - 0.5;
                        double dy = world.field_73012_v.nextDouble() - 0.5;
                        double dz = world.field_73012_v.nextDouble() - 0.5;
                        EntityIceShard iceshard = new EntityIceShard(world);
                        iceshard.func_70107_b(entity.field_70165_t + dx, entity.field_70163_u + dy + 0.5, entity.field_70161_v + dz);
                        iceshard.field_70159_w = dx * 1.5;
                        iceshard.field_70181_x = dy * 1.5;
                        iceshard.field_70179_y = dz * 1.5;
                        iceshard.setCaster((EntityLivingBase)entity);
                        iceshard.damageMultiplier = 1.3f;
                        world.func_72838_d((Entity)iceshard);
                    }
                }
            }
            entity.func_174820_d(slot, ItemStack.field_190927_a);
        } else {
            stack.func_77964_b(damage + 1);
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return false;
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            if (!(event.getEntityLiving() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (((EntityPlayer)event.getEntityLiving()).func_184607_cu() == null) {
                return;
            }
            ItemStack activeItemStack = player.func_184607_cu();
            if (activeItemStack != null && activeItemStack.func_77973_b() instanceof ItemIceShield && event.getSource().func_76364_f() instanceof EntityLivingBase && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)((EntityLivingBase)event.getSource().func_76364_f()))) {
                ((EntityLivingBase)event.getSource().func_76364_f()).func_70690_d(new PotionEffect(WizardryPotions.frost, 40, 0));
            }
        }
    }
}

