/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.integration.baubles.ASBaublesIntegration;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftTabs;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.integration.baubles.WizardryBaublesIntegration;
import electroblob.wizardry.util.InventoryUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNewArtefact
extends Item {
    private final EnumRarity rarity;
    private final AdditionalType type;
    private boolean enabled = true;

    public ItemNewArtefact(EnumRarity rarity, AdditionalType type) {
        this.func_77625_d(1);
        this.func_77637_a(AncientSpellcraftTabs.ANCIENTSPELLCRAFT_GEAR);
        this.rarity = rarity;
        this.type = type;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return ASBaublesIntegration.enabled() ? new ASBaublesIntegration.ArtefactBaubleProvider(this.type) : null;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.rarity == EnumRarity.EPIC;
    }

    public AdditionalType getType() {
        return this.type;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc", new Object[0]);
        if (!this.enabled) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:generic.disabled", new Style().func_150238_a(TextFormatting.RED), new Object[0]));
        }
    }

    public static boolean isNewArtefactActive(EntityPlayer player, Item artefact) {
        if (!(artefact instanceof ItemNewArtefact)) {
            throw new IllegalArgumentException("Not an ItemNewArtefact!");
        }
        if (!((ItemNewArtefact)artefact).enabled) {
            return false;
        }
        if (WizardryBaublesIntegration.enabled()) {
            return WizardryBaublesIntegration.isBaubleEquipped((EntityPlayer)player, (Item)artefact);
        }
        return InventoryUtils.getPrioritisedHotbarAndOffhand((EntityPlayer)player).stream().filter(s -> s.func_77973_b() instanceof ItemNewArtefact && ((ItemNewArtefact)s.func_77973_b()).type == ((ItemNewArtefact)artefact).type).limit(((ItemNewArtefact)artefact).type.maxAtOnce).anyMatch(s -> s.func_77973_b() == artefact);
    }

    public static enum AdditionalType {
        BELT(1),
        HEAD(1);

        public final int maxAtOnce;

        private AdditionalType(int maxAtOnce) {
            this.maxAtOnce = maxAtOnce;
        }
    }
}

