/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.data.Knowledge;
import com.windanesz.ancientspellcraft.data.SpellComponentList;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftTabs;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.spell.Spell;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRelic
extends Item {
    private final EnumRarity rarity;

    public ItemRelic(String name, EnumRarity rarity) {
        this.field_77777_bU = 1;
        this.func_77637_a(AncientSpellcraftTabs.ANCIENTSPELLCRAFT);
        this.rarity = rarity;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    public static Tier getTier(ItemStack stack) {
        switch (stack.func_77973_b().func_77613_e(stack)) {
            case COMMON: {
                return Tier.NOVICE;
            }
            case UNCOMMON: {
                return Tier.APPRENTICE;
            }
            case RARE: {
                return Tier.ADVANCED;
            }
            case EPIC: {
                return Tier.MASTER;
            }
        }
        return Tier.NOVICE;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return this.rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        if (advanced.func_194127_a()) {
            tooltip.add(TextFormatting.GOLD + "Ancient Relic");
        }
        if (ItemRelic.isResearched(stack)) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"item.ancientspellcraft:relic_researched", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.rarity == EnumRarity.EPIC;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public static void setResearched(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("researched") && stack.func_77978_p().func_74767_n("researched")) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("researched", true);
        stack.func_77982_d(nbt);
    }

    public static void setRelicContent(ItemStack stack, EntityPlayer player) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("researched") && stack.func_77978_p().func_74767_n("spell")) {
            return;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74778_a("spell", Knowledge.getRandomNextSpell(player, ItemRelic.getTier(stack)).getRegistryName().toString());
        stack.func_77982_d(nbt);
    }

    public static boolean isResearched(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("researched")) {
            return stack.func_77978_p().func_74767_n("researched");
        }
        return false;
    }

    @Nullable
    public static List<ItemStack> getSpellComponentItems(ItemStack stack) {
        Spell spell;
        if (stack.func_77973_b() instanceof ItemRelic && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("spell") && (spell = Spell.get((String)stack.func_77978_p().func_74779_i("spell"))) != null && SpellComponentList.containsSpell(spell)) {
            SpellComponentList componentList = SpellComponentList.lookupBySpell(spell);
            return Arrays.asList(componentList.getComponents());
        }
        return null;
    }

    @Nullable
    public static Spell getSpell(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemRelic && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("spell")) {
            Spell spell = Spell.get((String)stack.func_77978_p().func_74779_i("spell"));
            return spell;
        }
        return null;
    }
}

