/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.item.ItemArtefact;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSetArtefact
extends ItemASArtefact {
    public ArrayList<String> allArtefactSetItems;
    public int fullSetCount;
    public String setName;
    public String modid;

    public ItemSetArtefact(EnumRarity rarity, ItemArtefact.Type type, String setName, int fullSetCount, ArrayList<String> setItems) {
        super(rarity, type);
        this.allArtefactSetItems = setItems;
        this.fullSetCount = fullSetCount;
        this.setName = setName;
        this.modid = "ancientspellcraft";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, worldIn, tooltip, advanced);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        List artefacts = ItemSetArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0]);
        List<String> activeParts = ItemSetArtefact.getActiveSetPartList((ItemSetArtefact)stack.func_77973_b(), artefacts);
        int activePartCount = activeParts.size();
        String localizedSetName = I18n.func_135052_a((String)("set." + this.modid + ":" + this.setName), (Object[])new Object[0]);
        tooltip.add("\u00a76" + I18n.func_135052_a((String)("set." + this.modid + ":set_name_with_count"), (Object[])new Object[]{localizedSetName, activePartCount, this.fullSetCount}));
        if (activePartCount > 1) {
            tooltip.add("\u00a7d" + I18n.func_135052_a((String)("set." + this.modid + ":set_bonus"), (Object[])new Object[]{this.getSetBonusString(activePartCount)}));
            if (advanced.func_194127_a()) {
                for (String artefact : activeParts) {
                    tooltip.add("\u00a71" + I18n.func_135052_a((String)("item." + artefact + ".name"), (Object[])new Object[0]));
                }
            }
        }
    }

    public String getSetBonusString(int activePartCount) {
        return I18n.func_135052_a((String)("set." + this.modid + ":" + this.setName + ".bonus"), (Object[])new Object[]{(activePartCount - 1) * 5});
    }

    public static ArrayList<String> getAllArtefactSetItems(ItemSetArtefact setArtefact) {
        return setArtefact.allArtefactSetItems;
    }

    public static List<String> getActiveSetPartList(ItemSetArtefact setArtefact, List<ItemArtefact> activeArtefactList) {
        ArrayList<String> returnStringList = new ArrayList<String>();
        int activecount = activeArtefactList.size();
        for (String setItem : setArtefact.allArtefactSetItems) {
            for (ItemArtefact activeArtefact : activeArtefactList) {
                String setItemRegName = setArtefact.modid + ":" + setItem;
                if (!activeArtefact.getRegistryName().toString().equals(setItemRegName)) continue;
                returnStringList.add(activeArtefact.getRegistryName().toString());
            }
        }
        return returnStringList;
    }

    public static int getFullSetCount(ItemSetArtefact setArtefact) {
        return setArtefact.fullSetCount;
    }

    public static boolean isSetFull(ItemSetArtefact setArtefact, int activeParts) {
        return ItemSetArtefact.getFullSetCount(setArtefact) == activeParts;
    }

    public static String getSetName(ItemSetArtefact setArtefact) {
        return setArtefact.setName;
    }
}

