/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.registry;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class AncientSpellcraftLoot {
    private static LootTable UNCOMMON_ARTEFACTS;
    private static LootTable RARE_ARTEFACTS;
    private static LootTable EPIC_ARTEFACTS;

    private AncientSpellcraftLoot() {
    }

    public static void preInit() {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "chests/dungeon_additions"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "subsets/uncommon_artefacts"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "subsets/rare_artefacts"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "subsets/epic_artefacts"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ancientspellcraft", "entities/void_creeper"));
    }

    @SubscribeEvent
    public static void onLootTableLoadEvent(LootTableLoadEvent event) {
        if (Arrays.asList(AncientSpellcraft.settings.lootInjectionLocations).contains(event.getName())) {
            event.getTable().addPool(AncientSpellcraftLoot.getAdditive("ancientspellcraft:chests/dungeon_additions", "ancientspellcraft_ancientspellcraft_dungeon_additions"));
        }
        if (event.getName().toString().equals("ancientspellcraft:subsets/uncommon_artefacts")) {
            UNCOMMON_ARTEFACTS = event.getTable();
        } else if (event.getName().toString().equals("ancientspellcraft:subsets/rare_artefacts")) {
            RARE_ARTEFACTS = event.getTable();
        } else if (event.getName().toString().equals("ancientspellcraft:subsets/epic_artefacts")) {
            EPIC_ARTEFACTS = event.getTable();
        }
        if (Arrays.asList(AncientSpellcraft.settings.artefactInjectionLocations).contains(event.getName())) {
            LootPool sourcePool;
            LootPool targetPool;
            if (event.getName().toString().equals("ebwizardry:subsets/uncommon_artefacts") && UNCOMMON_ARTEFACTS != null) {
                targetPool = event.getTable().getPool("uncommon_artefacts");
                sourcePool = UNCOMMON_ARTEFACTS.getPool("main");
                AncientSpellcraftLoot.injectEntries(sourcePool, targetPool);
            }
            if (event.getName().toString().equals("ebwizardry:subsets/rare_artefacts") && RARE_ARTEFACTS != null) {
                targetPool = event.getTable().getPool("rare_artefacts");
                sourcePool = RARE_ARTEFACTS.getPool("main");
                AncientSpellcraftLoot.injectEntries(sourcePool, targetPool);
            }
            if (event.getName().toString().equals("ebwizardry:subsets/epic_artefacts") && EPIC_ARTEFACTS != null) {
                targetPool = event.getTable().getPool("epic_artefacts");
                sourcePool = EPIC_ARTEFACTS.getPool("main");
                AncientSpellcraftLoot.injectEntries(sourcePool, targetPool);
            }
        }
    }

    private static void injectEntries(LootPool sourcePool, LootPool targetPool) {
        List lootEntries = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)sourcePool, (String)"field_186453_a");
        for (LootEntry entry : lootEntries) {
            targetPool.addEntry(entry);
        }
    }

    private static LootPool getAdditive(String entryName, String poolName) {
        return new LootPool(new LootEntry[]{AncientSpellcraftLoot.getAdditiveEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "ancientspellcraft_" + poolName);
    }

    private static LootEntryTable getAdditiveEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation(name), weight, 0, new LootCondition[0], "ancientspellcraft_additive_entry");
    }
}

