/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSpells;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class BlockWeaving
extends SpellRay {
    public static final String TIMEOUT_COUNTDOWN = "pos_forget_countdown";
    public static final int COUNT = 1;
    public static final IStoredVariable<List<Location>> LOCATION_KEY = new IStoredVariable.StoredVariable("blockWeavingPrevPos", s -> NBTExtras.listToNBT((Collection)s, Location::toNBT), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, Location::fromNBT)), Persistence.ALWAYS).setSynced();
    Random rand = new Random();

    public BlockWeaving() {
        super("ancientspellcraft", "blockweaving", SpellActions.POINT, false);
        this.soundValues(0.7f, 1.2f, 0.4f);
        this.addProperties(new String[]{TIMEOUT_COUNTDOWN});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{LOCATION_KEY});
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return false;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        Vec3d origin = new Vec3d(caster.field_70165_t, caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e(), caster.field_70161_v);
        if (!this.shootSpell(world, origin, look, (EntityLivingBase)caster, ticksInUse, modifiers)) {
            return false;
        }
        if (this.casterSwingsArm(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers)) {
            caster.func_184609_a(hand);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            EntityPlayer player;
            if (side == EnumFacing.UP) {
                pos = pos.func_177972_a(side);
            }
            if (!(player = (EntityPlayer)caster).func_70093_af() && player.field_70170_p.field_72995_K) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.PATH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).time(180).clr(0.0f, 1.0f, 0.3f).spawn(world);
            }
            if (!player.field_70170_p.field_72995_K) {
                WizardData data = WizardData.get((EntityPlayer)player);
                List<Object> locations = (ArrayList<Location>)data.getVariable(LOCATION_KEY);
                if (player.func_70093_af()) {
                    if (!world.field_72995_K && data.hasSpellBeenDiscovered((Spell)this)) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getRegistryName() + ".forget", new Object[0]), true);
                    }
                    try {
                        if (locations != null && !locations.isEmpty()) {
                            locations.clear();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    data.sync();
                    return true;
                }
                if (locations != null && !locations.isEmpty()) {
                    boolean placedBlocks = false;
                    Location startingLoc = (Location)locations.get(locations.size() - 1);
                    if (startingLoc.dimension == player.field_71093_bK) {
                        if (player.func_184592_cb().func_190926_b() || !player.func_184592_cb().func_190926_b() && !(player.func_184592_cb().func_77973_b() instanceof ItemBlock)) {
                            if (!world.field_72995_K && data.hasSpellBeenDiscovered((Spell)this)) {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getRegistryName() + ".offhand_empty", new Object[0]), true);
                            }
                            return false;
                        }
                        ItemBlock itemBlock = (ItemBlock)player.func_184592_cb().func_77973_b();
                        int i = itemBlock.func_77647_b(player.func_184592_cb().func_77960_j());
                        ItemStack stack = new ItemStack(player.func_184592_cb().func_77973_b(), 1, i);
                        IBlockState iblockstate1 = itemBlock.func_179223_d().getStateForPlacement(player.field_70170_p, pos, side, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), i, (EntityLivingBase)player, EnumHand.OFF_HAND);
                        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)pos, (BlockPos)startingLoc.pos)) {
                            if (!player.func_175151_a(currPos, side, stack) || !player.field_70170_p.func_190527_a(((ItemBlock)stack.func_77973_b()).func_179223_d(), currPos, false, side, (Entity)player)) continue;
                            if (!player.func_184812_l_() && !ASUtils.shrinkInventoryStackByOne(player, stack)) break;
                            world.func_175656_a(currPos, ((ItemBlock)stack.func_77973_b()).func_179223_d().getExtendedState(iblockstate1, (IBlockAccess)player.field_70170_p, currPos));
                            placedBlocks = true;
                        }
                        locations = new ArrayList(1);
                        data.setVariable(LOCATION_KEY, locations);
                        locations.clear();
                        data.sync();
                        return true;
                    }
                    return false;
                }
                locations = (List)data.getVariable(LOCATION_KEY);
                if (locations == null) {
                    locations = new ArrayList<Location>(1);
                    data.setVariable(LOCATION_KEY, locations);
                }
                Location currLocation = new Location(pos, caster.field_71093_bK);
                locations.add(currLocation);
                data.sync();
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getRegistryName() + ".first_pos_set", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}), true);
                } else {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.PATH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).time(120).clr(0.0f, 1.0f, 0.3f).spawn(world);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean onEntityHit(World world, Entity entity, Vec3d vec3d, @Nullable EntityLivingBase entityLivingBase, Vec3d vec3d1, int i, SpellModifiers spellModifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase entityLivingBase, Vec3d vec3d, Vec3d vec3d1, int i, SpellModifiers spellModifiers) {
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
    }

    @SubscribeEvent
    public static void onRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack;
        Spell spell;
        if (event.getEntity() instanceof EntityPlayer && ((EntityPlayer)event.getEntity()).func_184614_ca().func_77973_b() instanceof ISpellCastingItem && event.getHand() == EnumHand.OFF_HAND && (spell = ((ISpellCastingItem)(stack = ((EntityPlayer)event.getEntity()).func_184614_ca()).func_77973_b()).getCurrentSpell(stack)) == AncientSpellcraftSpells.blockweaving) {
            event.setCanceled(true);
        }
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

