/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftPotions;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ChannelPower
extends SpellRay {
    public ChannelPower(String modID, String name, EnumAction action, boolean isContinuous) {
        super(modID, name, SpellActions.POINT, true);
        this.addProperties(new String[]{"effect_duration"});
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K && EntityUtils.isLiving((Entity)target) && target instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)target;
            if (!entityLivingBase.func_70644_a(MobEffects.field_188423_x)) {
                entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 60, 1));
            }
            if (ticksInUse > 40) {
                entityLivingBase.func_70690_d(new PotionEffect(AncientSpellcraftPotions.unlimited_power, (int)this.getProperty("effect_duration").floatValue()));
            }
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, double distance) {
        if (caster != null) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).entity((Entity)caster).pos(origin.func_178788_d(caster.func_174791_d())).length(distance).clr(0.98f, 0.6f + 0.3f * world.field_73012_v.nextFloat(), 0.98f).scale(MathHelper.func_76126_a((float)((float)world.func_82737_E() * 0.2f)) * 0.1f + 1.4f).spawn(world);
        } else {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).pos(origin).target(origin.func_178787_e(direction.func_186678_a(distance))).clr(0.98f, 0.6f + 0.3f * world.field_73012_v.nextFloat(), 0.98f).scale(MathHelper.func_76126_a((float)((float)world.func_82737_E() * 0.2f)) * 0.1f + 1.4f).spawn(world);
        }
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

