/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Conflagration
extends SpellAreaEffect {
    public static final String BURN_DURATION = "burn_duration";
    public static final String MAX_DAMAGE = "max_damage";

    public Conflagration() {
        super("ancientspellcraft", "conflagration", SpellActions.SUMMON, false);
        this.addProperties(new String[]{BURN_DURATION, MAX_DAMAGE});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean f = super.cast(world, caster, hand, ticksInUse, modifiers);
        Wizardry.proxy.shakeScreen(caster, 8.0f);
        if (!world.field_72995_K) {
            float radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
            List sphere = BlockUtils.getBlockSphere((BlockPos)caster.func_180425_c(), (double)radius);
            for (BlockPos currPos : sphere) {
                if (currPos.func_177954_c(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v) < 2.0 || world.field_73012_v.nextInt(4) > 2 || !world.func_175623_d(currPos.func_177972_a(EnumFacing.UP))) continue;
                world.func_175656_a(currPos.func_177972_a(EnumFacing.UP), Blocks.field_150480_ab.func_176223_P());
            }
        } else {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, caster.field_70165_t + 0.5, caster.field_70163_u + 0.5, caster.field_70161_v + 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
        return f;
    }

    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer && AllyDesignationSystem.isAllied((EntityLivingBase)((EntityPlayer)caster), (EntityLivingBase)target)) {
            return false;
        }
        if (target instanceof EntityPlayer) {
            Wizardry.proxy.shakeScreen((EntityPlayer)target, 8.0f);
        }
        target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.BLAST), Math.max(this.getProperty(MAX_DAMAGE).floatValue() - (float)target.func_70011_f(caster.field_70165_t + 0.5, caster.field_70163_u + 0.5, caster.field_70161_v + 0.5) * 4.0f, 0.0f) * modifiers.get("potency"));
        target.func_70015_d(this.getProperty(BURN_DURATION).intValue());
        double dx = target.field_70165_t - caster.field_70165_t;
        double dy = target.func_174813_aQ().field_72338_b + 1.0 - caster.field_70163_u;
        double dz = target.field_70161_v - caster.field_70161_v;
        target.field_70159_w = dx * 0.2;
        target.field_70181_x = dy * 0.1;
        target.field_70179_y = dz * 0.2;
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

