/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSounds;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockBookshelf;
import electroblob.wizardry.block.BlockImbuementAltar;
import electroblob.wizardry.block.BlockPedestal;
import electroblob.wizardry.block.BlockRunestone;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EssenceExtraction
extends SpellRay {
    public static final IStoredVariable<BlockPos> EXTRACTION_LOCATION = IStoredVariable.StoredVariable.ofBlockPos((String)"extractionLocation", (Persistence)Persistence.NEVER).setSynced();
    public static final IStoredVariable<Integer> EXTRACT_TICKS = IStoredVariable.StoredVariable.ofInt((String)"extractTicks", (Persistence)Persistence.NEVER);

    public EssenceExtraction() {
        super("ancientspellcraft", "essence_extraction", SpellActions.POINT, true);
        this.particleVelocity(-0.5);
        this.particleSpacing(0.4);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{EXTRACTION_LOCATION, EXTRACT_TICKS});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof BlockImbuementAltar || block instanceof BlockBookshelf || block instanceof BlockRunestone || block instanceof BlockPedestal)) {
            return false;
        }
        if (caster instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)caster;
            if (world.field_72995_K && ticksInUse == 0 || ticksInUse % 50 == 0) {
                this.playSound(world, caster, ticksInUse, -1, modifiers, new String[0]);
            }
            if (block instanceof BlockImbuementAltar && (player.func_184592_cb().func_190926_b() || player.func_184592_cb().func_77973_b() != WizardryItems.astral_diamond)) {
                if (!world.field_72995_K && world.func_82737_E() % 20L == 0L) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:essence_extraction.no_diamond", new Object[0]));
                }
                return true;
            }
            WizardData data = WizardData.get((EntityPlayer)player);
            if (data != null) {
                Integer extractTicks = (Integer)data.getVariable(EXTRACT_TICKS);
                BlockPos extractionLocation = (BlockPos)data.getVariable(EXTRACTION_LOCATION);
                if (extractTicks == null) {
                    extractTicks = 0;
                }
                if (extractionLocation != null) {
                    if (extractionLocation != pos && (extractionLocation.func_177958_n() != pos.func_177958_n() || extractionLocation.func_177956_o() != pos.func_177956_o() || extractionLocation.func_177952_p() != pos.func_177952_p())) {
                        data.setVariable(EXTRACTION_LOCATION, (Object)pos);
                        extractTicks = 0;
                    }
                } else {
                    data.setVariable(EXTRACTION_LOCATION, (Object)pos);
                    extractTicks = 0;
                }
                if (world.field_72995_K && Settings.generalSettings.shake_screen) {
                    int tick = extractTicks;
                    if (world.func_82737_E() % 10L == 0L && extractTicks > 0) {
                        EntityUtils.getEntitiesWithinRadius((double)15.0, (double)origin.field_72450_a, (double)origin.field_72448_b, (double)origin.field_72449_c, (World)world, EntityPlayer.class).forEach(p -> Wizardry.proxy.shakeScreen(p, (float)tick * 0.025f));
                    }
                }
                Integer tick = extractTicks;
                Integer n = extractTicks = Integer.valueOf(extractTicks + 1);
                data.setVariable(EXTRACT_TICKS, (Object)extractTicks);
                if (world.field_73012_v.nextInt(4) == 0) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                }
                if (block instanceof BlockImbuementAltar) {
                    if (extractTicks >= 200) {
                        if (!world.field_72995_K) {
                            world.func_72876_a(null, (double)(pos.func_177958_n() + 2), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, true);
                            world.func_72876_a(null, (double)(pos.func_177958_n() - 2), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, true);
                            world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 2), 1.0f, true);
                            world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - 2), 1.0f, true);
                            world.func_72876_a(null, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 4.0f, true);
                        }
                        data.setVariable(EXTRACT_TICKS, (Object)0);
                        data.setVariable(EXTRACTION_LOCATION, null);
                        if (!world.field_72995_K) {
                            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), AncientSpellcraftSounds.IMBUEMENT_TABLE_BREAK, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                            if (player.func_184592_cb().func_77973_b() == WizardryItems.astral_diamond) {
                                player.func_184592_cb().func_190918_g(1);
                                ItemStack newStack = new ItemStack(AncientSpellcraftItems.astral_diamond_charged);
                                if (player.func_184592_cb().func_190926_b()) {
                                    player.func_184611_a(EnumHand.OFF_HAND, newStack);
                                } else if (!player.field_71071_by.func_70441_a(newStack)) {
                                    player.func_71019_a(newStack, false);
                                }
                            }
                        }
                        world.func_175656_a(pos, AncientSpellcraftBlocks.IMBUEMENT_ALTAR_RUINED.func_176223_P());
                        return false;
                    }
                } else if (block instanceof BlockBookshelf) {
                    if (extractTicks >= 100) {
                        world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, false);
                        world.func_175698_g(pos);
                        for (int i = 0; i < ASUtils.getRandomNumberInRange(1, 3); ++i) {
                            Block.func_180635_a((World)world, (BlockPos)new BlockPos((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p()), (ItemStack)new ItemStack(Items.field_151055_y));
                        }
                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(WizardryItems.grand_crystal));
                    }
                } else if ((block instanceof BlockRunestone || block instanceof BlockPedestal) && extractTicks >= 100) {
                    Element element;
                    world.func_72876_a(null, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 1.0f, false);
                    if (block instanceof BlockRunestone) {
                        element = (Element)world.func_180495_p(pos).func_177229_b((IProperty)BlockRunestone.ELEMENT);
                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ancientspellcraft:crystal_shard_" + element.func_176610_l()))));
                    } else {
                        element = (Element)world.func_180495_p(pos).func_177229_b((IProperty)BlockPedestal.ELEMENT);
                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ancientspellcraft:crystal_shard_" + element.func_176610_l())), ASUtils.getRandomNumberInRange(3, 6)));
                    }
                    Block.func_180635_a((World)world, (BlockPos)new BlockPos((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p()), (ItemStack)new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), 1));
                    world.func_175698_g(pos);
                }
            }
        }
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        if (world.field_73012_v.nextInt(5) == 0) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(x, y, z).clr(1.0f, 1.0f, 0.65f).fade(0.7f, 0.0f, 1.0f).spawn(world);
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).scale(0.2f).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(6)).clr(1.0f, 1.0f, 0.65f).fade(0.7f, 0.0f, 1.0f).spawn(world);
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spell_book;
    }
}

