/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ManaFlare
extends SpellRay {
    public ManaFlare() {
        super("ancientspellcraft", "mana_flare", SpellActions.POINT, true);
        this.particleVelocity(-0.5);
        this.particleSpacing(0.4);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityLivingBase) {
            if (ASUtils.isManaStoringCastingItem(((EntityLivingBase)target).func_184614_ca().func_77973_b())) {
                return this.drainMana(((EntityLivingBase)target).func_184614_ca(), modifiers);
            }
            if (ASUtils.isManaStoringCastingItem(((EntityLivingBase)target).func_184592_cb().func_77973_b())) {
                return this.drainMana(((EntityLivingBase)target).func_184592_cb(), modifiers);
            }
        }
        return false;
    }

    private boolean drainMana(ItemStack target, SpellModifiers modifiers) {
        IManaStoringItem targetItem = (IManaStoringItem)target.func_77973_b();
        if (!targetItem.isManaEmpty(target)) {
            this.consumeMana(target, (int)modifiers.get("cost") * 2);
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    private void consumeMana(ItemStack stack, int mana) {
        ((IManaStoringItem)stack.func_77973_b()).setMana(stack, Math.max(((IManaStoringItem)stack.func_77973_b()).getMana(stack) - mana, 0));
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        if (world.field_73012_v.nextInt(5) == 0) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(x, y, z).clr(1.0f, 1.0f, 0.65f).fade(0.7f, 0.0f, 1.0f).spawn(world);
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(6)).clr(1.0f, 1.0f, 0.65f).fade(0.7f, 0.0f, 1.0f).spawn(world);
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spell_book;
    }
}

