/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.util.ASParticles;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SummonAnchor
extends Spell {
    private static String MAX_AFFECTED_ENTITIES = "max_affected_entities";

    public SummonAnchor() {
        super("ancientspellcraft", "summon_anchor", SpellActions.SUMMON, false);
        this.addProperties(new String[]{"blast_radius"});
        this.addProperties(new String[]{"duration"});
        this.addProperties(new String[]{"health"});
        this.addProperties(new String[]{MAX_AFFECTED_ENTITIES});
        this.soundValues(1.0f, 1.2f, 0.2f);
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double radius = this.getProperty("blast_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        int duration = Math.round(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
        boolean foundSummon = false;
        this.playSound(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, 0, 0, modifiers, new String[0]);
        List targets = EntityUtils.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
        int entityCount = this.getProperty(MAX_AFFECTED_ENTITIES).intValue();
        for (EntityLivingBase target : targets) {
            if (!(target instanceof ISummonedCreature) || ((ISummonedCreature)target).func_184753_b() != caster.func_110124_au()) continue;
            if (--entityCount <= 0) {
                return false;
            }
            ISummonedCreature summon = (ISummonedCreature)target;
            summon.setLifetime(summon.getLifetime() + Math.round(duration));
            if (target.func_110143_aJ() < target.func_110138_aP() && target.func_110143_aJ() > 0.0f) {
                target.func_70691_i(this.getProperty("health").floatValue() * modifiers.get("potency"));
            }
            foundSummon = true;
            if (!world.field_72995_K) continue;
            ParticleBuilder.create((ResourceLocation)ASParticles.SOUL_CHAIN).entity((Entity)caster).time(60).pos(0.0, (double)caster.func_70047_e() - 0.25, 0.0).target((Entity)target).seed(world.func_82737_E() - (long)ticksInUse).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.GUARDIAN_BEAM).entity((Entity)caster).time(60).pos(0.0, (double)caster.func_70047_e() - 0.25, 0.0).target((Entity)target).clr(139, 8, 168).spawn(world);
        }
        if (world.field_72995_K) {
            this.spawnSpellParticles(caster, caster.field_70170_p, radius);
        }
        return foundSummon;
    }

    private void spawnSpellParticles(EntityPlayer caster, World world, double radius) {
        if (world.field_72995_K) {
            float particleCount = 10.0f;
            float r = 0.0f;
            float g = 0.0f;
            float b = 237.0f;
            int i = 0;
            while ((float)i < particleCount) {
                double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                double y = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 1.0 + world.field_73012_v.nextDouble();
                double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(caster.field_70165_t, caster.func_174813_aQ().field_72338_b + 0.1, caster.field_70161_v).scale((float)radius * 0.8f).clr(51, 0, 102).spawn(world);
                ++i;
            }
        }
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

