/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.living.EntitySpiritBear;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SummonSpiritBear
extends Spell {
    private static final String POTENCY_ATTRIBUTE_MODIFIER = "potency";
    public static final IStoredVariable<UUID> SPIRIT_BEAR_UUID = IStoredVariable.StoredVariable.ofUUID((String)"spiritBearUUID", (Persistence)Persistence.ALWAYS);

    public SummonSpiritBear() {
        super("ancientspellcraft", "summon_spirit_bear", SpellActions.SUMMON, false);
        this.addProperties(new String[]{"summon_radius"});
        this.soundValues(0.7f, 1.2f, 0.4f);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{SPIRIT_BEAR_UUID});
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data = WizardData.get((EntityPlayer)caster);
        if (!world.field_72995_K) {
            BlockPos pos;
            Entity oldWolf = EntityUtils.getEntityByUUID((World)world, (UUID)((UUID)data.getVariable(SPIRIT_BEAR_UUID)));
            if (oldWolf != null) {
                oldWolf.func_70106_y();
            }
            if ((pos = BlockUtils.findNearbyFloorSpace((Entity)caster, (int)2, (int)4)) == null) {
                return false;
            }
            EntitySpiritBear bear = new EntitySpiritBear(world);
            bear.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            bear.setOwnerId(caster.func_110124_au());
            bear.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.get(POTENCY_ATTRIBUTE_MODIFIER) - 1.0f), 2));
            bear.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.amplified(POTENCY_ATTRIBUTE_MODIFIER, 1.5f) - 1.0f), 2));
            bear.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.amplified(POTENCY_ATTRIBUTE_MODIFIER, 0.05f) - 1.0f), 2));
            bear.func_70606_j(bear.func_110138_aP());
            world.func_72838_d((Entity)bear);
            data.setVariable(SPIRIT_BEAR_UUID, (Object)bear.func_110124_au());
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

