/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftPotions;
import com.windanesz.ancientspellcraft.spell.TimeKnot;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TemporalCasualty
extends SpellRay {
    public static final IStoredVariable<Long> CURSE_TEMPORAL_CASUALTY_LOOP_START = IStoredVariable.StoredVariable.ofLong((String)"curse_temporal_casualty_loop_start", (Persistence)Persistence.ALWAYS).setSynced().withTicker(TemporalCasualty::update);
    public static final int LOOP_DURATION = 24000;

    public TemporalCasualty() {
        super("ancientspellcraft", "curse_temporal_casualty", SpellActions.POINT, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{CURSE_TEMPORAL_CASUALTY_LOOP_START});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            WizardData data = WizardData.get((EntityPlayer)player);
            if (data == null) {
                return true;
            }
            NBTTagCompound compound = TimeKnot.storeCurrentPlayerData(player);
            data.setVariable(TimeKnot.TIME_KNOT_DATA, (Object)compound);
            data.setVariable(CURSE_TEMPORAL_CASUALTY_LOOP_START, (Object)(player.field_70170_p.func_82737_E() + 24000L));
            data.sync();
            if (player.func_70644_a(AncientSpellcraftPotions.time_knot)) {
                player.func_184589_d(AncientSpellcraftPotions.time_knot);
            }
            player.func_70690_d(new PotionEffect(AncientSpellcraftPotions.curse_temporal_casualty, Integer.MAX_VALUE, 0));
            return true;
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(1235712).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(544002).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(740160).spawn(world);
    }

    private static long update(EntityPlayer player, Long nextLoopStart) {
        if (nextLoopStart == null) {
            return 0L;
        }
        if (player.field_70170_p.func_82737_E() == nextLoopStart.longValue() && player.func_70644_a(AncientSpellcraftPotions.curse_temporal_casualty) && player.func_70089_S()) {
            TimeKnot.loopPlayer(player);
            long l = player.field_70170_p.func_82737_E() + 24000L;
            player.func_70690_d(new PotionEffect(AncientSpellcraftPotions.curse_temporal_casualty, Integer.MAX_VALUE, 0));
            return l;
        }
        return nextLoopStart;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

