/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftPotions;
import com.windanesz.ancientspellcraft.util.SpellTeleporter;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.packet.PacketTransportation;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class TimeKnot
extends SpellBuff {
    public static final IStoredVariable<NBTTagCompound> TIME_KNOT_DATA = IStoredVariable.StoredVariable.ofNBT((String)"time_knot_data", (Persistence)Persistence.ALWAYS).setSynced();

    public TimeKnot() {
        super("ancientspellcraft", "time_knot", 42.0f, 206.0f, 88.0f, new Supplier[]{() -> AncientSpellcraftPotions.time_knot});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{TIME_KNOT_DATA});
    }

    protected boolean applyEffects(EntityLivingBase caster, SpellModifiers modifiers) {
        float baseDur = this.getProperty(TimeKnot.getDurationKey((Potion)AncientSpellcraftPotions.time_knot)).floatValue();
        float durationUpgrade = modifiers.get(WizardryItems.duration_upgrade);
        float potency = modifiers.get("potency");
        if (potency > 1.0f) {
            potency = (potency - 1.0f) * 8.0f + 1.0f;
        }
        if (durationUpgrade > 1.0f) {
            durationUpgrade = (durationUpgrade - 1.0f) * 10.0f + 1.0f;
        }
        int duration = (int)(baseDur * potency * durationUpgrade);
        Iterator iterator = this.potionSet.iterator();
        while (iterator.hasNext()) {
            Potion potion;
            caster.func_70690_d(new PotionEffect(potion, (potion = (Potion)iterator.next()).func_76403_b() ? 1 : duration, (int)this.getProperty(TimeKnot.getStrengthKey((Potion)potion)).floatValue(), false, false));
        }
        return true;
    }

    protected int getBonusAmplifier(float potencyModifier) {
        return TimeKnot.getStandardBonusAmplifier((float)potencyModifier);
    }

    public boolean cast(World world, EntityPlayer player, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            this.spawnParticles(world, (EntityLivingBase)player, modifiers);
        }
        if (!player.func_70644_a(AncientSpellcraftPotions.time_knot)) {
            WizardData data;
            if (player.func_70644_a(AncientSpellcraftPotions.curse_temporal_casualty)) {
                player.func_184589_d(AncientSpellcraftPotions.curse_temporal_casualty);
            }
            if ((data = WizardData.get((EntityPlayer)player)) != null) {
                NBTTagCompound compound = TimeKnot.storeCurrentPlayerData(player);
                data.setVariable(TIME_KNOT_DATA, (Object)compound);
                data.sync();
            }
            return super.cast(world, player, hand, ticksInUse, modifiers);
        }
        return false;
    }

    public static NBTTagCompound storeCurrentPlayerData(EntityPlayer caster) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74780_a("PosX", caster.field_70165_t);
        compound.func_74780_a("PosY", caster.field_70163_u);
        compound.func_74780_a("PosZ", caster.field_70161_v);
        compound.func_74768_a("Dimension", caster.field_71093_bK);
        compound.func_74776_a("Health", caster.func_110143_aJ());
        compound.func_74776_a("AbsorptionAmount", caster.func_110139_bj());
        compound.func_74776_a("SaturationLevel", caster.func_71024_bL().func_75115_e());
        compound.func_74768_a("AirLevel", caster.func_70086_ai());
        compound.func_74768_a("FoodLevel", caster.func_71024_bL().func_75116_a());
        compound.func_74757_a("Burning", caster.func_70027_ad());
        if (!caster.func_193076_bZ().isEmpty()) {
            NBTTagList potionTagList = new NBTTagList();
            for (PotionEffect potioneffect : caster.func_193076_bZ().values()) {
                if (potioneffect.func_188419_a() == AncientSpellcraftPotions.time_knot) continue;
                potionTagList.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("ActiveEffects", (NBTBase)potionTagList);
        }
        return compound;
    }

    @SubscribeEvent
    public static void onPotionExpiryEvent(PotionEvent.PotionExpiryEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (event.getPotionEffect().func_188419_a() == AncientSpellcraftPotions.time_knot && player.func_70089_S() && player.func_110143_aJ() != 0.0f) {
                TimeKnot.loopPlayer(player);
            }
        }
    }

    public static void loopPlayer(EntityPlayer player) {
        NBTTagCompound compound;
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null && (compound = (NBTTagCompound)data.getVariable(TIME_KNOT_DATA)) != null) {
            try {
                if (player.field_70170_p.field_72995_K) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)player).clr(42, 206, 88).spawn(player.field_70170_p);
                }
                if (player.func_184218_aH()) {
                    player.func_184210_p();
                }
                TimeKnot.updatePlayerDataFromNBT(player, compound);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updatePlayerDataFromNBT(EntityPlayer player, NBTTagCompound compound) {
        if (compound != null) {
            int storedDim = compound.func_74762_e("Dimension");
            double posX = compound.func_74769_h("PosX");
            double posY = compound.func_74769_h("PosY");
            double posZ = compound.func_74769_h("PosZ");
            if (player.field_71093_bK == storedDim) {
                player.func_70634_a(posX, posY, posZ);
                PacketTransportation.Message message = new PacketTransportation.Message();
            } else {
                SpellTeleporter.teleportEntity(storedDim, posX, posY, posZ, false, player);
            }
            player.func_70606_j(compound.func_74760_g("Health"));
            player.func_110149_m(compound.func_74760_g("AbsorptionAmount"));
            player.func_71024_bL().func_75119_b(compound.func_74760_g("SaturationLevel"));
            player.func_71024_bL().func_75114_a(compound.func_74762_e("FoodLevel"));
            player.func_70050_g(compound.func_74762_e("AirLevel"));
            boolean burning = compound.func_74767_n("Burning");
            player.func_70066_B();
            ArrayList<Potion> activePotions = new ArrayList<Potion>();
            for (Potion potion : player.func_193076_bZ().keySet()) {
                activePotions.add(potion);
            }
            if (!activePotions.isEmpty()) {
                for (Potion activePotion : activePotions) {
                    player.func_184589_d(activePotion);
                }
            }
        }
        if (compound.func_150297_b("ActiveEffects", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("ActiveEffects", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                PotionEffect potioneffect = PotionEffect.func_82722_b((NBTTagCompound)nbttagcompound);
                if (potioneffect == null) continue;
                player.func_70690_d(potioneffect);
            }
        }
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        int i = 0;
        while ((float)i < this.particleCount) {
            double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(42, 206, 88).spawn(world);
            ++i;
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(42, 206, 88).spawn(world);
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

