/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.entity.construct.EntityTransportationPortal;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellConstructRanged;
import electroblob.wizardry.spell.Transportation;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TransportationPortal
extends SpellConstructRanged<EntityTransportationPortal> {
    public TransportationPortal(String modID, String name, EnumAction action, boolean isContinuous) {
        super(modID, name, EntityTransportationPortal::new, false);
        this.soundValues(1.0f, 1.1f, 0.1f);
        this.floor(true);
        this.overlap(false);
        this.addProperties(new String[]{"effect_duration"});
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)WizardryItems.charm_transportation)) {
            return super.cast(world, caster, hand, ticksInUse, modifiers);
        }
        if (!this.hasTargetDestination((EntityLivingBase)caster, modifiers)) {
            return false;
        }
        double range = this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        if (!world.field_72995_K) {
            Vec3d look = caster.func_70040_Z();
            double x = caster.field_70165_t + look.field_72450_a * range;
            double y = caster.func_174813_aQ().field_72338_b;
            double z = caster.field_70161_v + look.field_72449_c * range;
            if (!world.func_175623_d(new BlockPos(x, y, z)) || !world.func_175623_d(new BlockPos(caster.field_70165_t + look.field_72450_a * range / 2.0, y, caster.field_70161_v + look.field_72449_c * range / 2.0))) {
                x = caster.field_70165_t;
                z = caster.field_70161_v;
            }
            if (!this.spawnConstruct(world, x, y, z, EnumFacing.UP, (EntityLivingBase)caster, modifiers)) {
                return false;
            }
        }
        caster.func_184609_a(hand);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return false;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return false;
    }

    private boolean hasTargetDestination(EntityLivingBase entityLivingBaseCaster, SpellModifiers modifiers) {
        EntityPlayer caster;
        WizardData data;
        if (entityLivingBaseCaster instanceof EntityPlayer && (data = WizardData.get((EntityPlayer)(caster = (EntityPlayer)entityLivingBaseCaster))) != null) {
            List locations = (List)data.getVariable((IVariable)Transportation.LOCATIONS_KEY);
            if (locations != null && locations.isEmpty()) {
                if (!caster.field_70170_p.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ebwizardry:transportation.undefined", new Object[0]), true);
                }
                return false;
            }
            if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)WizardryItems.charm_transportation)) {
                List locationsInDimension;
                if (!ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)AncientSpellcraftItems.charm_rift_bottle) && (locationsInDimension = locations.stream().filter(l -> l.dimension == caster.field_71093_bK).collect(Collectors.toList())).isEmpty()) {
                    if (!caster.field_70170_p.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".wrongdimension", new Object[0]), true);
                    }
                    return false;
                }
                Location destination = TransportationPortal.getLocationAimedAt(caster, locations, 1.0f);
                if (destination == null) {
                    return false;
                }
            } else {
                Location destination = (Location)locations.get(locations.size() - 1);
                if (!ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)AncientSpellcraftItems.charm_rift_bottle) && destination.dimension != caster.field_71093_bK) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ebwizardry:transportation.wrongdimension", new Object[0]), true);
                    return false;
                }
                if (!TransportationPortal.testForCircleInDim((EntityLivingBase)caster, destination)) {
                    if (!caster.field_70170_p.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ebwizardry:transportation.missing", new Object[0]), true);
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static Location getLocationAimedAt(EntityPlayer player, List<Location> locations, float partialTicks) {
        return locations.stream().filter(l -> TransportationPortal.isLocationAimedAt(player, l.pos, partialTicks)).min(Comparator.comparingDouble(l -> TransportationPortal.getLookDeviationAngle(player, l.pos, partialTicks))).orElse(null);
    }

    public static boolean isLocationAimedAt(EntityPlayer player, BlockPos pos, float partialTicks) {
        Vec3d origin = player.func_174824_e(partialTicks);
        Vec3d centre = GeometryUtils.getCentre((BlockPos)pos);
        Vec3d direction = centre.func_178788_d(origin);
        double distance = direction.func_72433_c();
        return TransportationPortal.getLookDeviationAngle(player, pos, partialTicks) < TransportationPortal.getIconSize(distance);
    }

    public static double getLookDeviationAngle(EntityPlayer player, BlockPos pos, float partialTicks) {
        Vec3d origin = player.func_174824_e(partialTicks);
        Vec3d look = player.func_70676_i(partialTicks);
        Vec3d centre = GeometryUtils.getCentre((BlockPos)pos);
        Vec3d direction = centre.func_178788_d(origin);
        double distance = direction.func_72433_c();
        return Math.acos(direction.func_72430_b(look) / distance);
    }

    public static double getIconSize(double distance) {
        return 0.05 + 2.0 / (distance + 5.0);
    }

    private Location getStoneCircleLocation(EntityPlayer caster) {
        WizardData data = WizardData.get((EntityPlayer)caster);
        List locations = (List)data.getVariable((IVariable)Transportation.LOCATIONS_KEY);
        if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)WizardryItems.charm_transportation)) {
            if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)AncientSpellcraftItems.charm_rift_bottle)) {
                Location destination = TransportationPortal.getLocationAimedAt(caster, locations, 1.0f);
                return destination;
            }
            List<Location> locationsInDimension = locations.stream().filter(l -> l.dimension == caster.field_71093_bK).collect(Collectors.toList());
            Location destination = TransportationPortal.getLocationAimedAt(caster, locationsInDimension, 1.0f);
            return destination;
        }
        Location destination = (Location)locations.get(locations.size() - 1);
        return destination;
    }

    protected boolean spawnConstruct(World world, double x, double y, double z, @Nullable EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        try {
            if (this.getStoneCircleLocation((EntityPlayer)((EntityPlayer)caster)).pos == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        Location loc = this.getStoneCircleLocation((EntityPlayer)caster);
        if (loc.dimension != caster.field_71093_bK && !ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)AncientSpellcraftItems.charm_rift_bottle)) {
            if (!world.field_72995_K) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ebwizardry:transportation.wrongdimension", new Object[0]), true);
            }
            return false;
        }
        return super.spawnConstruct(world, x, y, z, side, caster, modifiers);
    }

    protected void addConstructExtras(EntityTransportationPortal construct, EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        try {
            if (this.getStoneCircleLocation((EntityPlayer)((EntityPlayer)caster)).pos != null) {
                construct.setTargetDim(this.getStoneCircleLocation((EntityPlayer)((EntityPlayer)caster)).dimension);
                construct.setTargetPos(this.getStoneCircleLocation((EntityPlayer)((EntityPlayer)caster)).pos);
            }
        }
        catch (Exception e) {
            AncientSpellcraft.logger.error("An error occurred during setting the target location of the Transportation Portal:");
            e.printStackTrace();
        }
    }

    public static boolean testForCircleInDim(EntityLivingBase caster, Location location) {
        MinecraftServer server = caster.func_130014_f_().func_73046_m();
        if (server != null) {
            WorldServer worldServer = server.func_71218_a(location.dimension);
            if (worldServer.func_180495_p(location.pos).func_185904_a().func_76230_c()) {
                return false;
            }
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0 || worldServer.func_180495_p(location.pos.func_177982_a(x, 0, z)).func_177230_c() == WizardryBlocks.transportation_stone) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

