/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.construct.EntityVenusFlyTrap;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class VenusFlyTrap
extends SpellRay {
    public VenusFlyTrap() {
        super("ancientspellcraft", "venus_fly_trap", SpellActions.POINT_DOWN, false);
        this.addProperties(new String[]{"damage", "effect_duration"});
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        double d0 = Math.min(target.field_70163_u, caster.field_70163_u);
        double d1 = Math.max(target.field_70163_u, caster.field_70163_u) + 1.0;
        float f = (float)MathHelper.func_181159_b((double)(target.field_70161_v - caster.field_70161_v), (double)(target.field_70165_t - caster.field_70165_t));
        this.spawnFangs(caster, f, d0, d1);
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        double d0 = Math.min((double)pos.func_177956_o(), caster.field_70163_u);
        double d1 = Math.max((double)pos.func_177956_o(), caster.field_70163_u) + 1.0;
        float f = (float)MathHelper.func_181159_b((double)((double)pos.func_177952_p() - caster.field_70161_v), (double)((double)pos.func_177958_n() - caster.field_70165_t));
        this.spawnFangs(caster, f, d0, d1);
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    private void spawnFangs(EntityLivingBase caster, float f, double d0, double d1) {
        for (int l = 0; l < 6; ++l) {
            if (l == 0) continue;
            double d2 = 1.25 * (double)(l + 1);
            int j = l;
            this.spawnFang(caster, caster.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, caster.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
        }
    }

    private void spawnFang(EntityLivingBase caster, double posX, double posZ, double p_190876_5_, double posY, float p_190876_9_, int p_190876_10_) {
        BlockPos blockpos = new BlockPos(posX, posY, posZ);
        boolean flag = false;
        double d0 = 0.0;
        do {
            IBlockState iblockstate;
            AxisAlignedBB axisalignedbb;
            if (caster.field_70170_p.func_175677_d(blockpos, true) || !caster.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
            if (!caster.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = caster.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)caster.field_70170_p, blockpos)) != null) {
                d0 = axisalignedbb.field_72337_e;
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
        if (flag) {
            EntityVenusFlyTrap entityVenusFlyTrap = new EntityVenusFlyTrap(caster.field_70170_p, posX, (double)blockpos.func_177956_o() + d0, posZ, p_190876_9_, p_190876_10_, caster);
            caster.field_70170_p.func_72838_d((Entity)entityVenusFlyTrap);
        }
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

