/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.util;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import com.windanesz.ancientspellcraft.spell.PocketDimension;
import electroblob.wizardry.data.WizardData;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PocketDimUtils {
    private PocketDimUtils() {
    }

    public static void onPlayerEnteredPocketDim(EntityPlayerMP player, World pocketWorld) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            NBTTagCompound compound = (NBTTagCompound)data.getVariable(PocketDimension.POCKET_DIM_LOCATION);
            if (compound != null) {
                BlockPos pocketLocation = NBTUtil.func_186861_c((NBTTagCompound)compound);
                player.func_70634_a((double)pocketLocation.func_177958_n(), (double)(pocketLocation.func_177956_o() + 3), (double)pocketLocation.func_177952_p());
            } else {
                BlockPos pocketLocation = PocketDimUtils.findSuitablePocketPos(pocketWorld);
                PocketDimUtils.createPocket(pocketLocation, pocketWorld);
                player.func_70107_b((double)pocketLocation.func_177958_n(), (double)(pocketLocation.func_177956_o() + 3), (double)pocketLocation.func_177952_p());
                PocketDimUtils.setPocketDimLocation(data, pocketLocation);
                if (!pocketWorld.field_72995_K) {
                    data.sync();
                }
            }
        }
    }

    public static void setPocketDimLocation(WizardData data, BlockPos pocketLocation) {
        NBTTagCompound nbt = NBTUtil.func_186859_a((BlockPos)pocketLocation.func_177972_a(EnumFacing.UP));
        data.setVariable(PocketDimension.POCKET_DIM_LOCATION, (Object)nbt);
    }

    public static void onPlayerLeftPocketDim(EntityPlayerMP player, World pocketWorld) {
    }

    public static void createPocket(BlockPos pos, World pocketWorld) {
        PocketDimUtils.createPlatform(pos, pocketWorld);
        PocketDimUtils.createWalls(pos, pocketWorld);
        PocketDimUtils.createPlatform(pos.func_177967_a(EnumFacing.UP, 11), pocketWorld);
        pocketWorld.func_175656_a(pos, AncientSpellcraftBlocks.DIMENSION_FOCUS.func_176223_P());
    }

    private static BlockPos findSuitablePocketPos(World pocketWorld) {
        BlockPos currPos = new BlockPos(0, 1, 0);
        while (!PocketDimUtils.isSuitablePosition(currPos, pocketWorld)) {
            currPos = PocketDimUtils.getRandomLocationWithOffset(currPos);
        }
        return currPos;
    }

    private static boolean isSuitablePosition(BlockPos pos, World pocketWorld) {
        boolean isFree = true;
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)pos.func_177967_a(EnumFacing.WEST, 250).func_177967_a(EnumFacing.SOUTH, 250).func_177972_a(EnumFacing.DOWN), (BlockPos)pos.func_177967_a(EnumFacing.EAST, 250).func_177967_a(EnumFacing.NORTH, 250).func_177972_a(EnumFacing.UP))) {
            if (pocketWorld.func_175623_d(currPos)) continue;
            isFree = false;
            break;
        }
        return isFree;
    }

    private static BlockPos getRandomLocationWithOffset(BlockPos origPos) {
        int i;
        Random rand = new Random();
        int n = i = rand.nextBoolean() ? 1 : -1;
        EnumFacing facing = rand.nextBoolean() ? EnumFacing.NORTH : (rand.nextBoolean() ? EnumFacing.SOUTH : (rand.nextBoolean() ? EnumFacing.EAST : EnumFacing.WEST));
        return origPos.func_177967_a(facing, 300 * i);
    }

    private static void createPlatform(BlockPos pos, World pocketWorld) {
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)pos.func_177967_a(EnumFacing.SOUTH, 6).func_177967_a(EnumFacing.WEST, 6), (BlockPos)pos.func_177967_a(EnumFacing.NORTH, 6).func_177967_a(EnumFacing.EAST, 6))) {
            pocketWorld.func_175656_a(currPos, AncientSpellcraftBlocks.DIMENSION_BOUNDARY.func_176223_P());
        }
    }

    private static void createWalls(BlockPos center, World pocketWorld) {
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.SOUTH, 6).func_177967_a(EnumFacing.WEST, 6), (BlockPos)center.func_177967_a(EnumFacing.NORTH, 6).func_177967_a(EnumFacing.WEST, 6).func_177967_a(EnumFacing.UP, 10))) {
            pocketWorld.func_175656_a(currPos, AncientSpellcraftBlocks.DIMENSION_BOUNDARY.func_176223_P());
        }
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.SOUTH, 6).func_177967_a(EnumFacing.EAST, 6), (BlockPos)center.func_177967_a(EnumFacing.NORTH, 6).func_177967_a(EnumFacing.EAST, 6).func_177967_a(EnumFacing.UP, 10))) {
            pocketWorld.func_175656_a(currPos, AncientSpellcraftBlocks.DIMENSION_BOUNDARY.func_176223_P());
        }
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.SOUTH, 6).func_177967_a(EnumFacing.EAST, -6), (BlockPos)center.func_177967_a(EnumFacing.SOUTH, 6).func_177967_a(EnumFacing.EAST, 6).func_177967_a(EnumFacing.UP, 10))) {
            pocketWorld.func_175656_a(currPos, AncientSpellcraftBlocks.DIMENSION_BOUNDARY.func_176223_P());
        }
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)center.func_177967_a(EnumFacing.NORTH, 6).func_177967_a(EnumFacing.WEST, -6), (BlockPos)center.func_177967_a(EnumFacing.NORTH, 6).func_177967_a(EnumFacing.WEST, 6).func_177967_a(EnumFacing.UP, 10))) {
            pocketWorld.func_175656_a(currPos, AncientSpellcraftBlocks.DIMENSION_BOUNDARY.func_176223_P());
        }
    }
}

