/*
 * Decompiled with CFR 0.152.
 */
package shadows.spawn.asm;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import shadows.ApotheosisCore;
import shadows.ApotheosisTransformer;
import shadows.CustomClassWriter;

public class SpawnerTransformer
implements ApotheosisTransformer.IApotheosisTransformer {
    @Override
    public boolean accepts(String name, String transformedName) {
        return "net.minecraft.tileentity.TileEntityMobSpawner$2".equals(transformedName);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!ApotheosisCore.enableSpawner) {
            return basicClass;
        }
        ApotheosisCore.LOG.info("Transforming TileEntityMobSpawner$2...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode method = (MethodNode)classNode.methods.get(1);
        if (method != null) {
            AbstractInsnNode toRemove = null;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode n = method.instructions.get(i);
                if (n.getOpcode() != 18) continue;
                toRemove = n;
                break;
            }
            if (toRemove != null) {
                method.instructions.set(toRemove, (AbstractInsnNode)new MethodInsnNode(184, "shadows/spawn/asm/SpawnerHooks", "getSpawnerClass", "()Ljava/lang/Class;", false));
                CustomClassWriter writer = new CustomClassWriter(3);
                classNode.accept((ClassVisitor)writer);
                ApotheosisCore.LOG.info("Successfully transformed TileEntityMobSpawner$2");
                return writer.toByteArray();
            }
        }
        ApotheosisCore.LOG.info("Failed transforming TileEntityMobSpawner$2");
        return basicClass;
    }
}

