/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items;

import com.google.common.base.Preconditions;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.AtumUtils;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemLoot
extends Item
implements IOreDictEntry {
    private static final NonNullList<LootEntry> LOOT_ENTRIES = NonNullList.func_191196_a();

    public static void createLootItems() {
        for (Type type : Type.values()) {
            for (Quality quality : Quality.values()) {
                ItemLoot item = new ItemLoot();
                if (quality == Quality.DIRTY) {
                    item.func_77625_d(64);
                } else {
                    item.func_77625_d(16);
                }
                LOOT_ENTRIES.add((Object)new LootEntry(quality, quality.getWeight()));
                AtumRegistry.registerItem(item, "loot." + quality.func_176610_l() + "." + type.func_176610_l());
            }
        }
    }

    public static Item getLootItem(Type type, Quality quality) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("atum", AtumUtils.toRegistryName("loot." + quality.func_176610_l() + "." + type.func_176610_l())));
    }

    public static Type getType(Item item) {
        if (!(item instanceof ItemLoot)) {
            Atum.LOG.error("Item is not a loot artifact");
        } else {
            for (Quality quality : Quality.values()) {
                Preconditions.checkNotNull((Object)item.getRegistryName(), (Object)"registryName");
                Type type = Type.byString(item.getRegistryName().func_110623_a().replace("loot_", "").replace(quality.func_176610_l(), "").replace("_", ""));
                if (type == null) continue;
                return type;
            }
        }
        return Type.IDOL;
    }

    public static Quality getQuality(Item item) {
        if (!(item instanceof ItemLoot)) {
            Atum.LOG.error("Item is not a loot artifact");
        } else {
            for (Type type : Type.values()) {
                Preconditions.checkNotNull((Object)item.getRegistryName(), (Object)"registryName");
                Quality quality = Quality.byString(item.getRegistryName().func_110623_a().replace("loot_", "").replace(type.func_176610_l(), "").replace("_", ""));
                if (quality == null) continue;
                return quality;
            }
        }
        return Quality.DIRTY;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemStack stack;
        World world = entityItem.field_70170_p;
        IBlockState state = world.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)entityItem.field_70165_t), MathHelper.func_76128_c((double)entityItem.field_70163_u), MathHelper.func_76128_c((double)entityItem.field_70161_v)));
        if ((state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i || state.func_177230_c() instanceof BlockCauldron && (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) > 0) && (stack = entityItem.func_92059_d()).func_77973_b() instanceof ItemLoot && String.valueOf(stack.func_77973_b().getRegistryName()).contains("dirty") && !world.field_72995_K) {
            while (stack.func_190916_E() > 0) {
                Item item = ItemLoot.getLootItem(ItemLoot.getType(stack.func_77973_b()), ((LootEntry)WeightedRandom.func_76271_a((Random)ItemLoot.field_77697_d, ItemLoot.LOOT_ENTRIES)).quality);
                if (field_77697_d.nextFloat() <= 0.1f) {
                    stack.func_190918_g(1);
                    world.func_184148_a(null, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, SoundEvents.field_187635_cQ, entityItem.func_184176_by(), 0.8f, 0.8f + entityItem.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    continue;
                }
                world.func_72838_d((Entity)new EntityItem(world, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, new ItemStack(item)));
                world.func_184148_a(null, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, SoundEvents.field_187604_bf, entityItem.func_184176_by(), 0.8f, 0.8f + entityItem.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                stack.func_190918_g(1);
            }
        }
        return super.onEntityItemUpdate(entityItem);
    }

    @Override
    public void getOreDictEntries() {
        OreDictHelper.add(this, "relic");
    }

    public static class LootEntry
    extends WeightedRandom.Item {
        final Quality quality;

        LootEntry(Quality quality, int weight) {
            super(weight);
            this.quality = quality;
        }
    }

    public static enum Quality implements IStringSerializable
    {
        DIRTY("dirty", 0),
        SILVER("silver", 48),
        GOLD("gold", 25),
        SAPPHIRE("sapphire", 20),
        RUBY("ruby", 15),
        EMERALD("emerald", 10),
        DIAMOND("diamond", 5);

        private final String unlocalizedName;
        private final int weight;

        private Quality(String name, int lootWeight) {
            this.unlocalizedName = name;
            this.weight = lootWeight;
        }

        public static Quality byString(String name) {
            for (Quality quality : Quality.values()) {
                if (!quality.func_176610_l().equals(name)) continue;
                return quality;
            }
            return null;
        }

        public int getWeight() {
            return this.weight;
        }

        @Nonnull
        public String func_176610_l() {
            return this.unlocalizedName;
        }
    }

    public static enum Type implements IStringSerializable
    {
        IDOL("idol"),
        NECKLACE("necklace"),
        RING("ring"),
        BROACH("broach"),
        SCEPTER("scepter");

        private final String unlocalizedName;

        private Type(String name) {
            this.unlocalizedName = name;
        }

        public static Type byString(String name) {
            for (Type type : Type.values()) {
                if (!type.func_176610_l().equals(name)) continue;
                return type;
            }
            return null;
        }

        @Nonnull
        public String func_176610_l() {
            return this.unlocalizedName;
        }
    }
}

