/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class BlockStateAdapter
extends TypeAdapter<IBlockState> {
    public IBlockState read(JsonReader reader) throws IOException {
        IBlockState blockState;
        String fullString;
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        String blockString = fullString = reader.nextString();
        int startIndex = fullString.indexOf(91);
        int stopIndex = fullString.indexOf(93);
        if (startIndex != -1) {
            blockString = fullString.substring(0, startIndex);
            if (stopIndex < startIndex) {
                BetterMineshafts.LOGGER.error("variants.json: Malformed property {}. Missing a bracket?", (Object)fullString);
                BetterMineshafts.LOGGER.error("Using air instead...");
                return Blocks.field_150350_a.func_176223_P();
            }
            String currKey = "";
            StringBuilder currString = new StringBuilder();
            for (int index = startIndex + 1; index <= stopIndex; ++index) {
                char currChar = fullString.charAt(index);
                if (currChar == '=') {
                    currKey = currString.toString();
                    currString = new StringBuilder();
                    continue;
                }
                if (currChar == ',' || currChar == ']') {
                    properties.put(currKey, currString.toString());
                    currString = new StringBuilder();
                    continue;
                }
                currString.append(fullString.charAt(index));
            }
        }
        try {
            blockState = Block.func_149684_b((String)blockString).func_176223_P();
        }
        catch (Exception e) {
            BetterMineshafts.LOGGER.error("variants.json: Unable to read block '{}': {}", (Object)blockString, (Object)e.toString());
            BetterMineshafts.LOGGER.error("Using air instead...");
            return Blocks.field_150350_a.func_176223_P();
        }
        if (blockState == null) {
            BetterMineshafts.LOGGER.error("variants.json: Unable to read block '{}': null block returned.", (Object)blockString);
            BetterMineshafts.LOGGER.error("Using air instead...");
            return Blocks.field_150350_a.func_176223_P();
        }
        if (properties.size() > 0) {
            blockState = this.getConfiguredBlockState(blockState, properties);
        }
        return blockState;
    }

    private <T extends Enum<T>> IBlockState getConfiguredBlockState(IBlockState blockState, Map<String, String> properties) {
        Block block = blockState.func_177230_c();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                boolean found = false;
                block3: for (Class<?> blockClass = block.getClass(); blockClass != Block.class && !found; blockClass = blockClass.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = blockClass.getDeclaredFields()) {
                        IProperty property;
                        field.setAccessible(true);
                        Object _field = field.get(blockState);
                        if (!(_field instanceof IProperty) || !(property = (IProperty)_field).func_177701_a().equals(key)) continue;
                        Object val = property.func_185929_b(value).orNull();
                        Class blockEnumClass = property.func_177699_b();
                        blockState = blockState.func_177226_a(property, (Comparable)Objects.requireNonNull(blockEnumClass.cast(val)));
                        found = true;
                        continue block3;
                    }
                }
                if (found) continue;
                BetterMineshafts.LOGGER.error("variants.json: Unable to find property {} for block {}", (Object)key, (Object)block.func_149732_F());
            }
            catch (Exception e) {
                BetterMineshafts.LOGGER.error("variants.json: Encountered error while attempting to apply property {}={} to block {}: {}", (Object)key, (Object)value, (Object)block.func_149732_F(), (Object)e.toString());
            }
        }
        return blockState;
    }

    public void write(JsonWriter writer, IBlockState blockState) throws IOException {
        if (blockState == null) {
            writer.nullValue();
            return;
        }
        writer.value(String.valueOf(blockState));
    }
}

