/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.util.BoxUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class SmallTunnelTurn
extends MineshaftPiece {
    private TurnDirection turnDirection;
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 4;

    public SmallTunnelTurn() {
    }

    public SmallTunnelTurn(int i, int chunkPieceLen, Random random, StructureBoundingBox blockBox, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, chunkPieceLen, settings);
        this.func_186164_a(direction);
        this.turnDirection = random.nextBoolean() ? TurnDirection.LEFT : TurnDirection.RIGHT;
        this.field_74887_e = blockBox;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143012_a(NBTTagCompound tag) {
        super.func_143012_a(tag);
        tag.func_74768_a("TurnDirection", this.turnDirection.value);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143011_b(NBTTagCompound tag, TemplateManager templateManager) {
        super.func_143011_b(tag, templateManager);
        this.turnDirection = TurnDirection.valueOf(tag.func_74762_e("TurnDirection"));
    }

    public static StructureBoundingBox determineBoxPosition(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing direction) {
        StructureBoundingBox blockBox = BoxUtil.boxFromCoordsWithRotation(x, y, z, 5, 5, 5, direction);
        StructureComponent intersectingPiece = StructureComponent.func_74883_a(list, (StructureBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
        EnumFacing direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        EnumFacing nextDirection = this.turnDirection == TurnDirection.LEFT ? direction.func_176735_f() : direction.func_176746_e();
        switch (nextDirection) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, nextDirection, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, nextDirection, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, nextDirection, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, nextDirection, this.func_74877_c(), this.pieceChainLen);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.func_74860_a(world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 4)) {
            return false;
        }
        EnumFacing direction = this.func_186165_e();
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 1, 0, 4, 4, 4, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 4, 0, 4, this.getFloorSelector());
        this.fill(world, box, 1, 1, 0, 3, 3, 3, AIR);
        this.replaceAir(world, box, 1, 0, 0, 3, 0, 4, this.getMainBlock());
        this.fill(world, box, 2, 1, 0, 2, 1, 1, Blocks.field_150448_aq.func_176223_P());
        if (this.turnDirection == TurnDirection.LEFT) {
            if (direction == EnumFacing.NORTH || direction == EnumFacing.EAST) {
                this.generateLeftTurn(world, box);
            } else {
                this.generateRightTurn(world, box);
            }
        } else if (direction == EnumFacing.NORTH || direction == EnumFacing.EAST) {
            this.generateRightTurn(world, box);
        } else {
            this.generateLeftTurn(world, box);
        }
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 4, 3, 4);
        this.addVines(world, box, random, 1, 0, 1, 3, 4, 3);
        return true;
    }

    private void generateLeftTurn(World world, StructureBoundingBox box) {
        this.fill(world, box, 0, 1, 1, 0, 3, 3, AIR);
        this.fill(world, box, 0, 0, 0, 0, 0, 3, this.getMainBlock());
        this.fill(world, box, 2, 1, 2, 2, 1, 2, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST));
        this.fill(world, box, 0, 1, 2, 1, 1, 2, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST));
    }

    private void generateRightTurn(World world, StructureBoundingBox box) {
        this.fill(world, box, 4, 1, 1, 4, 3, 3, AIR);
        this.fill(world, box, 4, 0, 0, 4, 0, 3, this.getMainBlock());
        this.fill(world, box, 2, 1, 2, 2, 1, 2, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST));
        this.fill(world, box, 3, 1, 2, 4, 1, 2, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST));
    }

    public static enum TurnDirection {
        LEFT(0),
        RIGHT(1);

        private final int value;

        private TurnDirection(int value) {
            this.value = value;
        }

        public static TurnDirection valueOf(int value) {
            return Arrays.stream(TurnDirection.values()).filter(dir -> dir.value == value).findFirst().get();
        }
    }
}

