/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardtype;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.SchematicPart;
import chanceCubes.rewards.rewardtype.IRewardType;
import chanceCubes.util.CustomSchematic;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class SchematicRewardType
implements IRewardType {
    private SchematicPart part;

    public SchematicRewardType(SchematicPart part) {
        this.part = part;
    }

    @Override
    public void trigger(final World world, final int x, final int y, final int z, final EntityPlayer player) {
        final CustomSchematic schematic = this.part.getSchematic();
        if (schematic == null) {
            CCubesCore.logger.log(Level.ERROR, "Failed to load a schematic reward with the file name " + this.part.getFileName());
            return;
        }
        final ArrayList<OffsetBlock> stack = new ArrayList<OffsetBlock>();
        for (OffsetBlock osb : schematic.getBlocks()) {
            if (!schematic.includeAirBlocks() && osb.getBlockState().func_177230_c().equals(Blocks.field_150350_a)) continue;
            stack.add(osb);
        }
        Scheduler.scheduleTask(new Task("Schematic_Spawn_Delay", schematic.getDelay()){

            @Override
            public void callback() {
                Scheduler.scheduleTask(new Task("Schematic_Reward_Block_Spawn", -1, schematic.getSpacingDelay() < 1.0f ? 1 : (int)schematic.getSpacingDelay()){

                    @Override
                    public void callback() {
                    }

                    @Override
                    public void update() {
                        float lessThan1 = 0.0f;
                        while (lessThan1 < 1.0f && !stack.isEmpty()) {
                            BlockPos pos;
                            OffsetBlock osb = (OffsetBlock)stack.remove(0);
                            if (schematic.isRelativeToPlayer()) {
                                pos = new BlockPos((int)Math.floor(player.field_70165_t) + osb.xOff.getIntValue(), (int)Math.floor(player.field_70163_u) + osb.yOff.getIntValue(), (int)Math.floor(player.field_70161_v) + osb.zOff.getIntValue());
                                if (world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockAccess)world, pos) && osb.getBlockState().func_177230_c() instanceof BlockAir) continue;
                                osb.spawnInWorld(world, (int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
                            } else {
                                pos = new BlockPos(x + osb.xOff.getIntValue(), y + osb.yOff.getIntValue(), z + osb.zOff.getIntValue());
                                if (world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockAccess)world, pos) && osb.getBlockState().func_177230_c() instanceof BlockAir) continue;
                                osb.spawnInWorld(world, x, y, z);
                            }
                            lessThan1 += schematic.getSpacingDelay();
                            if (stack.size() != 0) continue;
                            lessThan1 = 1.0f;
                        }
                        if (stack.size() == 0) {
                            Scheduler.removeTask(this);
                        }
                    }
                });
            }
        });
    }
}

