/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import svenhjol.charm.enchanting.feature.ExtraCurses;
import svenhjol.meson.MesonEnchantment;
import svenhjol.meson.helper.SoundHelper;
import svenhjol.meson.iface.IMesonEnchantment;

public class EnchantmentClumsinessCurse
extends MesonEnchantment
implements IMesonEnchantment.ICurse {
    private double clumsiness = ExtraCurses.clumsinessMissChance;

    public EnchantmentClumsinessCurse() {
        super("clumsiness_curse", Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.WEAPON, EntityEquipmentSlot.MAINHAND);
    }

    @Override
    public String getModId() {
        return "charm";
    }

    @Override
    public void onBreakDrop(EntityPlayer player, BlockEvent.HarvestDropsEvent event) {
        if (this.isHeldItemEnchanted(player, this) && (double)player.field_70170_p.field_73012_v.nextFloat() < this.clumsiness) {
            event.setDropChance(0.0f);
        }
    }

    @Override
    public void onAttack(EntityPlayer player, AttackEntityEvent event) {
        this.tryMiss(player, (Event)event);
    }

    @Override
    public void onInteract(EntityPlayer player, PlayerInteractEvent.RightClickBlock event) {
        this.tryMiss(player, (Event)event);
    }

    @Override
    public void onItemUseStop(EntityPlayer player, LivingEntityUseItemEvent.Stop event) {
        this.tryMiss(player, (Event)event);
    }

    private void tryMiss(EntityPlayer player, Event event) {
        if (this.isHeldItemEnchanted(player, this) && (double)player.field_70170_p.field_73012_v.nextFloat() < this.clumsiness) {
            event.setCanceled(true);
            this.playSound(player);
        }
    }

    private void playSound(EntityPlayer player) {
        SoundHelper.playerSound(player, SoundEvents.field_187635_cQ, 0.5f, 1.5f, 0.15f, null);
    }
}

