/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.tweaks.feature.CompassBinding;
import svenhjol.meson.MesonItem;
import svenhjol.meson.helper.ItemNBTHelper;
import svenhjol.meson.helper.TextHelper;

public class ItemBoundCompass
extends MesonItem {
    private static final String POSX = "posX";
    private static final String POSY = "posY";
    private static final String POSZ = "posZ";
    private static final String COLOR = "Quark:ItemNameDye";
    private static final String ROTA = "rota";
    private static final String ROTATION = "rotation";
    private static final String LASTUPDATE = "lastUpdateTick";

    public ItemBoundCompass() {
        super("bound_compass");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entityIn) {
                double angle;
                boolean validDimension;
                BlockPos pos;
                EntityLivingBase entity;
                if (entityIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean hasEntity = entityIn != null;
                Object object = entity = hasEntity ? entityIn : stack.func_82836_z();
                if (world == null) {
                    world = ((Entity)Objects.requireNonNull(entity)).field_70170_p;
                }
                if ((pos = ItemBoundCompass.this.getPos(stack)) != null) {
                    validDimension = world.field_73011_w.getDimension() == pos.func_177956_o();
                } else {
                    pos = world.field_73011_w.getSpawnPoint();
                    boolean bl = validDimension = world.field_73011_w.getDimension() == 0;
                }
                if (validDimension) {
                    double yaw = hasEntity ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
                    yaw = MathHelper.func_191273_b((double)(yaw / 360.0), (double)1.0);
                    double relAngle = this.getPosToAngle((Entity)entity, pos) / (Math.PI * 2);
                    angle = 0.5 - (yaw - 0.25 - relAngle);
                } else {
                    angle = Math.random();
                }
                if (hasEntity) {
                    angle = this.wobble(world, stack, angle);
                }
                return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
            }

            @SideOnly(value=Side.CLIENT)
            private double wobble(World worldIn, ItemStack stack, double angle) {
                if (!stack.func_77942_o()) {
                    return 0.0;
                }
                double rotation = ItemNBTHelper.getDouble(stack, ItemBoundCompass.ROTATION, 0.0);
                double rota = ItemNBTHelper.getDouble(stack, ItemBoundCompass.ROTA, 0.0);
                long lastUpdateTick = ItemNBTHelper.getLong(stack, ItemBoundCompass.LASTUPDATE, 0L);
                if (worldIn.func_82737_E() != lastUpdateTick) {
                    lastUpdateTick = worldIn.func_82737_E();
                    double d0 = angle - rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    rota += d0 * 0.1;
                    rotation = MathHelper.func_191273_b((double)(rotation + (rota *= 0.8)), (double)1.0);
                }
                ItemNBTHelper.setLong(stack, ItemBoundCompass.LASTUPDATE, lastUpdateTick);
                ItemNBTHelper.setDouble(stack, ItemBoundCompass.ROTATION, rotation);
                ItemNBTHelper.setDouble(stack, ItemBoundCompass.ROTA, rota);
                return rotation;
            }

            @SideOnly(value=Side.CLIENT)
            private double getFrameRotation(EntityItemFrame frame) {
                return MathHelper.func_188209_b((int)(180 + Objects.requireNonNull(frame.field_174860_b).func_176736_b() * 90));
            }

            @SideOnly(value=Side.CLIENT)
            private double getPosToAngle(Entity entity, BlockPos pos) {
                return Math.atan2((double)pos.func_177952_p() - entity.field_70161_v, (double)pos.func_177958_n() - entity.field_70165_t);
            }
        });
    }

    @Override
    public String getModId() {
        return "charm";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!CompassBinding.showInformation) {
            return;
        }
        BlockPos pos = this.getPos(stack);
        TextFormatting color = TextHelper.getTextFormattingByDyeDamage(ItemBoundCompass.getColor(stack));
        if (pos != null) {
            String x = String.valueOf(pos.func_177958_n());
            String z = String.valueOf(pos.func_177952_p());
            String dim = String.valueOf(pos.func_177956_o());
            tooltip.add(color + x + " " + z + ", " + I18n.func_135052_a((String)"dimension", (Object[])new Object[0]) + " " + dim);
        }
    }

    public static ItemStack setPos(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setInt(stack, POSX, pos.func_177958_n());
        ItemNBTHelper.setInt(stack, POSY, pos.func_177956_o());
        ItemNBTHelper.setInt(stack, POSZ, pos.func_177952_p());
        return stack;
    }

    public static ItemStack setColor(ItemStack stack, int meta) {
        if (meta > 0) {
            ItemNBTHelper.setInt(stack, COLOR, meta);
        }
        return stack;
    }

    public static int getColor(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, COLOR, 0);
    }

    public BlockPos getPos(ItemStack stack) {
        if (stack.func_77942_o()) {
            int x = ItemNBTHelper.getInt(stack, POSX, 0);
            int y = ItemNBTHelper.getInt(stack, POSY, 0);
            int z = ItemNBTHelper.getInt(stack, POSZ, 0);
            return new BlockPos(x, y, z);
        }
        return null;
    }
}

