/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.init.Biomes;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.meson.Feature;

public class VindicatorsInRoofedForest
extends Feature {
    public static int weight;
    public static double johnny;

    @Override
    public String getDescription() {
        return "Vindicators can be found wandering in Roofed Forest biomes.";
    }

    @Override
    public void configure() {
        super.configure();
        weight = this.propInt("Spawn weight", "The higher this value, the more vindicators will spawn.", 90);
        johnny = this.propDouble("Chance for Johnny", "Chance (out of 1.0) of a vindicator spawning as Johnny.", 0.05);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Biome.SpawnListEntry vindicatorEntry = new Biome.SpawnListEntry(EntityVindicator.class, weight, 1, 3);
        Biome roofedForest = Biomes.field_150585_R;
        roofedForest.func_76747_a(EnumCreatureType.MONSTER).add(vindicatorEntry);
    }

    @SubscribeEvent
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (!event.isSpawner() && event.getEntityLiving() instanceof EntityVindicator && event.getResult() != Event.Result.DENY && event.getEntityLiving().field_70170_p instanceof WorldServer) {
            if (event.getEntityLiving().func_180425_c().func_177956_o() < event.getEntityLiving().field_70170_p.func_181545_F()) {
                event.setResult(Event.Result.DENY);
            }
            if ((double)event.getWorld().field_73012_v.nextFloat() <= johnny) {
                event.getEntityLiving().func_96094_a("Johnny");
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

