/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.meson.Feature;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonLoader;
import svenhjol.meson.helper.ConfigHelper;
import svenhjol.meson.iface.IFMLEvents;

public abstract class Module
implements IFMLEvents {
    public List<Feature> features = new ArrayList<Feature>();
    public boolean enabled;
    public MesonLoader loader;
    public Configuration config;

    public void setup(MesonLoader loader, Configuration config) {
        this.loader = loader;
        this.config = config;
        this.configure();
    }

    public void configure() {
        this.features.forEach(feature -> {
            this.loader.features.add((Feature)feature);
            feature.enabled = ConfigHelper.propBoolean(this.config, feature.getName(), this.getName(), feature.getDescription(), feature.enabledByDefault);
            feature.setup(this);
        });
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getDescription() {
        return this.getName();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Meson.log("Starting module " + this.getName());
        this.features.stream().filter(Feature::isEnabled).forEach(feature -> {
            this.loader.enabledFeatures.add(feature.getClass());
            Meson.log("Starting feature " + feature.getName());
            feature.preInit(event);
        });
    }

    @Override
    public void init(FMLInitializationEvent event) {
        this.features.stream().filter(Feature::isEnabled).forEach(f -> f.init(event));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        this.features.stream().filter(Feature::isEnabled).forEach(f -> f.postInit(event));
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        this.features.stream().filter(Feature::isEnabled).forEach(f -> f.serverStarting(event));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        this.features.stream().filter(Feature::isEnabled).forEach(f -> f.preInitClient(event));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        this.features.stream().filter(Feature::isEnabled).forEach(f -> f.initClient(event));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postInitClient(FMLPostInitializationEvent event) {
        this.features.stream().filter(Feature::isEnabled).forEach(f -> f.postInitClient(event));
    }
}

