/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.tweaks.feature;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import svenhjol.meson.Feature;
import svenhjol.meson.Meson;
import svenhjol.meson.helper.ObfuscationHelper;

public class RemoveNitwits
extends Feature {
    @Override
    public String getDescription() {
        return "Removes nitwits as spawnable villagers.";
    }

    @SubscribeEvent
    public void onVillagerSpawn(EntityJoinWorldEvent event) {
        if (!event.isCanceled() && !event.getWorld().field_72995_K && event.getEntity() instanceof EntityVillager) {
            int i = 0;
            EntityVillager villager = (EntityVillager)event.getEntity();
            ResourceLocation res = villager.getProfessionForge().getRegistryName();
            DifficultyInstance difficulty = event.getWorld().func_175649_E(new BlockPos((Entity)villager));
            while (res != null && res.toString().equals("minecraft:nitwit")) {
                VillagerRegistry.setRandomProfession((EntityVillager)villager, (Random)event.getWorld().field_73012_v);
                res = villager.getProfessionForge().getRegistryName();
                if (++i <= 20) continue;
            }
            if (i > 0) {
                ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)villager, (Object)0, (String)ObfuscationHelper.Fields.CAREER_LEVEL[2], (String)ObfuscationHelper.Fields.CAREER_LEVEL[1]);
                villager.func_190672_a(difficulty, null, false);
                Meson.debug("Changed nitwit to " + res);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

