/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.charm.base.CharmLootTables;
import svenhjol.charm.world.item.ItemTotemOfShielding;
import svenhjol.meson.Feature;
import svenhjol.meson.helper.ItemHelper;
import svenhjol.meson.helper.LootHelper;

public class TotemOfShielding
extends Feature {
    public static Item totem;
    public static double damageMultiplier;
    public static int maxHealth;
    public static boolean addToLoot;
    public static boolean addToIllusioner;

    @Override
    public String getDescription() {
        return "With the Totem of Shielding in your offhand (shield) slot, any damage you take is absorbed by the totem instead.";
    }

    @Override
    public void configure() {
        super.configure();
        damageMultiplier = this.propDouble("Damage multiplier", "The incoming player damage is multiplied by this amount before being transferred to the totem.", 0.75);
        maxHealth = this.propInt("Maximum Health", "Maximum durability of the totem.", 100);
        addToLoot = this.propBoolean("Add to loot", "Add the totem to mansions, pyramids and jungle temple loot.", true);
        addToIllusioner = this.propBoolean("Add as Illusioner drop", "If Illusioners are enabled, add the totem as a possible drop.", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        totem = new ItemTotemOfShielding();
        ItemHelper.availableTotems.add(new ItemStack(totem));
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (!event.isCanceled() && event.getEntityLiving() instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.getEntityLiving()).func_184592_cb()).func_77973_b() instanceof ItemTotemOfShielding) {
            double totemDamage = (double)event.getAmount() * damageMultiplier;
            boolean totemDead = stack.func_96631_a((int)Math.ceil(totemDamage), player.field_70170_p.field_73012_v, (EntityPlayerMP)player);
            if (totemDead) {
                stack.func_190918_g(1);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_191263_gW, SoundCategory.BLOCKS, 0.8f, 1.0f);
            } else {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, 1.25f);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (!addToLoot) {
            return;
        }
        int weight = 0;
        int quality = 0;
        LootFunction[] functions = new LootFunction[]{};
        LootCondition[] conditions = new LootCondition[]{};
        if (event.getName().equals((Object)LootTableList.field_191192_o)) {
            weight = 12;
        }
        if (event.getName().equals((Object)LootTableList.field_186429_k)) {
            weight = 10;
        }
        if (event.getName().equals((Object)LootTableList.field_186430_l)) {
            weight = 10;
        }
        if (event.getName().equals((Object)CharmLootTables.VILLAGE_PRIEST)) {
            weight = 2;
        }
        if (event.getName().equals((Object)CharmLootTables.TREASURE_VALUABLE)) {
            weight = 12;
        }
        if (event.getName().equals((Object)CharmLootTables.TREASURE_RARE)) {
            weight = 16;
        }
        if (weight > 0) {
            LootHelper.addToLootTable(event.getTable(), totem, weight, quality, functions, conditions);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

