/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.decorator;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import svenhjol.meson.Meson;
import svenhjol.meson.decorator.MesonDecoratorItems;
import svenhjol.meson.decorator.MesonDecoratorTheme;

public abstract class MesonInnerDecorator {
    protected Random rand;
    protected World world;
    protected StructureComponent structure;
    protected StructureBoundingBox box;
    protected MesonDecoratorTheme theme;
    protected MesonDecoratorItems items;

    public MesonInnerDecorator(StructureComponent structure, World world, StructureBoundingBox box) {
        this.structure = structure;
        this.world = world;
        this.box = box;
        this.rand = new Random();
        this.rand.setSeed(structure.hashCode());
        try {
            this.theme = this.getThemeClass().getConstructor(MesonInnerDecorator.class).newInstance(this);
        }
        catch (Exception e) {
            Meson.runtimeException("Could not instantiate required decorator classes");
        }
        this.items = new MesonDecoratorItems(this);
    }

    protected abstract Class<? extends MesonDecoratorTheme> getThemeClass();

    public abstract void generate();

    public StructureComponent getStructure() {
        return this.structure;
    }

    public World getWorld() {
        return this.world;
    }

    public StructureBoundingBox getBox() {
        return this.box;
    }

    public Random getRand() {
        return this.rand;
    }

    public MesonDecoratorTheme getTheme() {
        return this.theme;
    }

    public void add(Block block, int x, int y, int z) {
        this.add(block.func_176223_P(), x, y, z, EnumFacing.NORTH);
    }

    public void add(Block block, int x, int y, int z, EnumFacing facing) {
        this.add(block.func_176223_P(), x, y, z, facing);
    }

    public void add(IBlockState state, int x, int y, int z) {
        this.add(state, x, y, z, EnumFacing.NORTH);
    }

    public void add(IBlockState state, int x, int y, int z, EnumFacing facing) {
        BlockPos place = new BlockPos(x, y, z);
        this.setBlockState(state, place, facing);
    }

    public void addRow(List<IBlockState> states, int x, int y, int z, EnumFacing direction, EnumFacing facing) {
        BlockPos pos = new BlockPos(x, y, z);
        int i = 0;
        for (IBlockState state : states) {
            BlockPos offset = pos.func_177967_a(direction, i++);
            this.add(state, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p(), facing);
        }
    }

    public void fill(Block block, int x0, int y0, int z0, int x1, int y1, int z1, boolean overwrite) {
        this.fill(block.func_176223_P(), x0, y0, z0, x1, y1, z1, EnumFacing.NORTH, overwrite);
    }

    public void fill(IBlockState state, int x0, int y0, int z0, int x1, int y1, int z1, EnumFacing facing, boolean overwrite) {
        this.fillWithBlocks(state, x0, y0, z0, x1, y1, z1, facing, overwrite);
    }

    public TileEntity addTileEntity(BlockPos pos, IBlockState state, EnumFacing facing) {
        BlockPos place = this.getRelativePos(pos);
        if (this.isNotInBox(place)) {
            return null;
        }
        TileEntity tile = this.world.func_175625_s(place);
        if (tile != null) {
            return null;
        }
        this.setBlockState(state, pos, facing);
        return this.world.func_175625_s(place);
    }

    public boolean chance(float chance) {
        return this.rand.nextFloat() <= chance;
    }

    protected boolean common() {
        return this.chance(Meson.DEBUG ? 1.0f : 0.85f);
    }

    protected boolean uncommon() {
        return this.chance(Meson.DEBUG ? 1.0f : 0.25f);
    }

    protected boolean valuable() {
        return this.chance(Meson.DEBUG ? 1.0f : 0.05f);
    }

    protected boolean rare() {
        return this.chance(Meson.DEBUG ? 1.0f : 0.005f);
    }

    public void fillWithBlocks(IBlockState state, int x0, int y0, int z0, int x1, int y1, int z1, EnumFacing facing, boolean overwrite) {
        for (int y = y0; y <= y1; ++y) {
            for (int x = x0; x <= x1; ++x) {
                for (int z = z0; z <= z1; ++z) {
                    BlockPos place = new BlockPos(x, y, z);
                    if (!overwrite && this.getBlockStateFromPos(place).func_185904_a() != Material.field_151579_a) continue;
                    this.setBlockState(state, place, facing);
                }
            }
        }
    }

    public void setBlockState(IBlockState state, BlockPos pos, EnumFacing facing) {
        BlockPos place = this.getRelativePos(pos);
        if (!this.box.func_175898_b((Vec3i)place)) {
            return;
        }
        state = this.getRotatedState(facing, state);
        this.world.func_180501_a(place, this.getRelativeState(state), 2);
    }

    public IBlockState getBlockStateFromPos(BlockPos pos) {
        int xo = this.getXWithOffset(pos.func_177958_n(), pos.func_177952_p());
        int yo = this.getYWithOffset(pos.func_177956_o());
        int zo = this.getZWithOffset(pos.func_177958_n(), pos.func_177952_p());
        BlockPos newpos = new BlockPos(xo, yo, zo);
        return this.world.func_180495_p(newpos);
    }

    public int getXWithOffset(int x, int z) {
        EnumFacing enumfacing = this.structure.func_186165_e();
        if (enumfacing == null) {
            return x;
        }
        switch (enumfacing) {
            case NORTH: 
            case SOUTH: {
                return this.structure.func_74874_b().field_78897_a + x;
            }
            case WEST: {
                return this.structure.func_74874_b().field_78893_d - z;
            }
            case EAST: {
                return this.structure.func_74874_b().field_78897_a + z;
            }
        }
        return x;
    }

    public int getYWithOffset(int y) {
        return this.structure.func_186165_e() == null ? y : y + this.structure.func_74874_b().field_78895_b;
    }

    public int getZWithOffset(int x, int z) {
        EnumFacing enumfacing = this.structure.func_186165_e();
        if (enumfacing == null) {
            return z;
        }
        switch (enumfacing) {
            case NORTH: {
                return this.structure.func_74874_b().field_78892_f - z;
            }
            case SOUTH: {
                return this.structure.func_74874_b().field_78896_c + z;
            }
            case WEST: 
            case EAST: {
                return this.structure.func_74874_b().field_78896_c + x;
            }
        }
        return z;
    }

    public BlockPos getRelativePos(BlockPos pos) {
        return new BlockPos(this.getXWithOffset(pos.func_177958_n(), pos.func_177952_p()), this.getYWithOffset(pos.func_177956_o()), this.getZWithOffset(pos.func_177958_n(), pos.func_177952_p()));
    }

    public IBlockState getRelativeState(IBlockState original) {
        return this.getRotatedState(this.structure.func_186165_e(), original);
    }

    public EnumFacing getRelativeFacing(EnumFacing facing) {
        return this.getRotatedFacing(this.structure.func_186165_e(), facing);
    }

    public IBlockState getRotatedState(EnumFacing axis, IBlockState original) {
        Mirror mirror;
        Rotation rotation;
        if (axis == null) {
            rotation = Rotation.NONE;
            mirror = Mirror.NONE;
        } else {
            switch (axis) {
                case SOUTH: {
                    mirror = Mirror.LEFT_RIGHT;
                    rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    mirror = Mirror.LEFT_RIGHT;
                    rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    mirror = Mirror.NONE;
                    rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    mirror = Mirror.NONE;
                    rotation = Rotation.NONE;
                }
            }
        }
        return original.func_185902_a(mirror).func_185907_a(rotation);
    }

    public EnumFacing getRotatedFacing(EnumFacing axis, EnumFacing facing) {
        Mirror mirror;
        Rotation rotation;
        if (axis == null) {
            rotation = Rotation.NONE;
            mirror = Mirror.NONE;
        } else {
            switch (axis) {
                case SOUTH: {
                    mirror = Mirror.LEFT_RIGHT;
                    rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    mirror = Mirror.LEFT_RIGHT;
                    rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    mirror = Mirror.NONE;
                    rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    mirror = Mirror.NONE;
                    rotation = Rotation.NONE;
                }
            }
        }
        return rotation.func_185830_a(mirror.func_185800_a(facing)).func_185831_a(facing);
    }

    public float getRotatedAngle(EnumFacing axis, float angle) {
        float newAngle = angle;
        if (axis != null) {
            switch (axis) {
                case SOUTH: {
                    newAngle += 270.0f;
                    break;
                }
                case WEST: {
                    newAngle += 180.0f;
                    break;
                }
                case EAST: {
                    newAngle += 90.0f;
                    break;
                }
            }
        }
        return newAngle;
    }

    public boolean isNotInBox(BlockPos pos) {
        return !this.box.func_175898_b((Vec3i)pos);
    }
}

