/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.client.render;

import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.danknull.api.DankNullItemModes;
import p455w0rd.danknull.api.IDankNullHandler;
import p455w0rd.danknull.init.ModConfig;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.init.ModKeyBindings;
import p455w0rd.danknull.inventory.DankNullHandler;
import p455w0rd.danknull.inventory.cap.CapabilityDankNull;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rdslib.util.GuiUtils;
import p455w0rdslib.util.RenderUtils;
import p455w0rdslib.util.TextUtils;

public class HUDRenderer {
    @SideOnly(value=Side.CLIENT)
    public static void renderHUD(Minecraft mc, ScaledResolution scaledRes) {
        if (!ModConfig.Options.showHUD || !mc.field_71442_b.func_78755_b() && !mc.field_71439_g.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack currentItem = mc.field_71439_g.field_71071_by.func_70448_g();
        if (currentItem.func_190926_b() || !ItemDankNull.isDankNull(currentItem)) {
            currentItem = mc.field_71439_g.func_184592_cb();
        }
        if (!currentItem.func_190926_b() && ItemDankNull.isDankNull(currentItem)) {
            IDankNullHandler dankNullHandler = (IDankNullHandler)currentItem.getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null);
            if (dankNullHandler.getSelected() < 0) {
                return;
            }
            ItemStack selectedStack = dankNullHandler.getFullStackInSlot(dankNullHandler.getSelected());
            TextureManager tm = mc.field_71446_o;
            if (tm != null && !selectedStack.func_190926_b()) {
                boolean isOreDicted;
                tm.func_110577_a(new ResourceLocation("danknull", "textures/gui/danknullscreen0.png"));
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                GuiUtils.drawTexturedModalRect((int)(scaledRes.func_78326_a() - 106), (int)(scaledRes.func_78328_b() - 45), (int)0, (int)210, (int)106, (int)45, (float)0.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                mc.field_71466_p.func_175063_a(currentItem.func_82833_r(), (float)(scaledRes.func_78326_a() * 2 - 212 + 55), (float)(scaledRes.func_78328_b() * 2 - 83), dankNullHandler.getTier().getHexColor(true));
                String selectedStackName = selectedStack.func_82833_r();
                int itemNameWidth = mc.field_71466_p.func_78256_a(selectedStackName);
                if (itemNameWidth >= 88 && selectedStackName.length() >= 14) {
                    selectedStackName = selectedStackName.substring(0, 14).trim() + "...";
                }
                DankNullItemModes.ItemPlacementMode placementMode = dankNullHandler.getPlacementMode(selectedStack);
                mc.field_71466_p.func_175063_a(TextUtils.translate((String)"dn.selected_item.desc") + ": " + selectedStackName, (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 72), 0xFFFFFF);
                mc.field_71466_p.func_175063_a(TextUtils.translate((String)"dn.count.desc") + ": " + (ItemDankNull.getTier(currentItem) == ModGlobals.DankNullTier.CREATIVE ? "Infinite" : Integer.valueOf(selectedStack.func_190916_E())), (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 61), 0xFFFFFF);
                mc.field_71466_p.func_175063_a(TextUtils.translate((String)"dn.place.desc") + ": " + placementMode.getTooltip().replace(TextUtils.translate((String)"dn.extract.desc").toLowerCase(Locale.ENGLISH), TextUtils.translate((String)"dn.place.desc").toLowerCase(Locale.ENGLISH)).replace(TextUtils.translate((String)"dn.extract.desc"), TextUtils.translate((String)"dn.place.desc")), (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 50), 0xFFFFFF);
                mc.field_71466_p.func_175063_a(TextUtils.translate((String)"dn.extract.desc") + ": " + dankNullHandler.getExtractionMode(selectedStack).getTooltip(), (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 40), 0xFFFFFF);
                String keyBind = ModKeyBindings.getOpenDankNullKeyBind().getDisplayName();
                mc.field_71466_p.func_175063_a(keyBind.equalsIgnoreCase("none") ? TextUtils.translate((String)"dn.no_open_keybind.desc") : TextUtils.translate((String)"dn.open_with.desc") + " " + keyBind, (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 29), 0xFFFFFF);
                String oreDictMode = TextUtils.translate((String)"dn.ore_dictionary.desc") + ": " + (dankNullHandler.isOre(selectedStack) ? TextUtils.translate((String)"dn.enabled.desc") : TextUtils.translate((String)"dn.disabled.desc"));
                boolean bl = isOreDicted = DankNullHandler.getOreNames(selectedStack).size() > 0;
                if (!isOreDicted) {
                    oreDictMode = TextUtils.translate((String)"dn.not_oredicted.desc");
                }
                mc.field_71466_p.func_175063_a(oreDictMode, (float)(scaledRes.func_78326_a() * 2 - 212 + 45), (float)(scaledRes.func_78328_b() * 2 - 18), 0xFFFFFF);
                RenderHelper.func_74520_c();
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtils.getRenderItem().func_180450_b(currentItem, scaledRes.func_78326_a() - 106 + 5, scaledRes.func_78328_b() - 20);
                GlStateManager.func_179121_F();
            }
        }
    }

    public static void toggleHUD() {
        ModConfig.Options.showHUD = !ModConfig.Options.showHUD;
        ModConfig.getInstance().get("client", "showHUD", true).setValue(ModConfig.Options.showHUD);
        ModConfig.getInstance().save();
    }
}

