/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import p455w0rd.danknull.api.DankNullItemModes;
import p455w0rd.danknull.api.IDankNullHandler;
import p455w0rd.danknull.init.ModConfig;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.inventory.cap.CapabilityDankNull;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rdslib.util.ItemUtils;

public class DankNullHandler
implements IDankNullHandler {
    private ModGlobals.DankNullTier tier;
    private NonNullList<ItemStack> stacks;
    private Map<ItemStack, Boolean> oreStacks;
    private Map<ItemStack, DankNullItemModes.ItemExtractionMode> extractionStacks;
    private Map<ItemStack, DankNullItemModes.ItemPlacementMode> placementStacks;
    public int selected;
    public boolean isLocked;

    public DankNullHandler(NBTTagCompound nbt) {
        CapabilityDankNull.DANK_NULL_CAPABILITY.readNBT((Object)this, null, (NBTBase)nbt);
    }

    public DankNullHandler(ModGlobals.DankNullTier tier) {
        this.tier = tier;
        this.stacks = NonNullList.func_191197_a((int)(this.tier.getNumRows() * 9), (Object)ItemStack.field_190927_a);
        this.oreStacks = new HashMap<ItemStack, Boolean>();
        this.extractionStacks = new HashMap<ItemStack, DankNullItemModes.ItemExtractionMode>();
        this.placementStacks = new HashMap<ItemStack, DankNullItemModes.ItemPlacementMode>();
        this.selected = -1;
        this.isLocked = false;
    }

    @Override
    @Nonnull
    public ItemStack getExtractableStackInSlot(int slot) {
        this.validateSlot(slot);
        ItemStack slotStack = ((ItemStack)this.getStackList().get(slot)).func_77946_l();
        if (!slotStack.func_190926_b()) {
            if (this.getExtractionMode(slotStack) == DankNullItemModes.ItemExtractionMode.KEEP_ALL) {
                slotStack = ItemStack.field_190927_a;
            } else {
                int amountToBeKept = this.getExtractionMode(slotStack).getNumberToKeep();
                if (slotStack.func_190916_E() > amountToBeKept) {
                    ItemStack availableStack = slotStack.func_77946_l();
                    availableStack.func_190920_e(slotStack.func_190916_E() - amountToBeKept);
                    return availableStack;
                }
                return ItemStack.field_190927_a;
            }
        }
        return slotStack;
    }

    @Override
    public ItemStack getFullStackInSlot(int slot) {
        this.validateSlot(slot);
        return (ItemStack)this.getStackList().get(slot);
    }

    @Override
    @Nonnull
    public ItemStack getRenderableStackForSlot(int slot) {
        ItemStack visualStack = this.getStackInSlot(slot).func_77946_l();
        if (!visualStack.func_190926_b()) {
            visualStack.func_190920_e(1);
        }
        return visualStack;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlot(slot);
        this.getStackList().set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public void setStackInSlotNoUpdate(int slot, @Nonnull ItemStack stack) {
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int i;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        stack = this.convertOreDict(stack);
        slot = -1;
        for (i = 0; i < this.getStackList().size(); ++i) {
            if (((ItemStack)this.getStackList().get(i)).func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((ItemStack)this.getStackList().get(i)))) continue;
            slot = i;
            break;
        }
        if (slot == -1) {
            for (i = 0; i < this.getStackList().size(); ++i) {
                if (!((ItemStack)this.getStackList().get(i)).func_190926_b()) continue;
                slot = i;
                break;
            }
        }
        if (slot < 0 || slot >= this.getSlots()) {
            return stack;
        }
        ItemStack existing = (ItemStack)this.getStackList().get(slot);
        if (existing.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
            return stack;
        }
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.getStackList().set(slot, (Object)stack.func_77946_l());
            } else {
                existing.func_190917_f(stack.func_190916_E());
            }
            ItemStack slotStack = (ItemStack)this.getStackList().get(slot);
            if (slotStack.func_190916_E() > this.getSlotLimit(slot)) {
                slotStack.func_190920_e(this.getSlotLimit(slot));
            }
            this.onContentsChanged(slot);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean isOreDictFiltered(ItemStack stack) {
        for (ItemStack storedStack : this.getStackList()) {
            if (storedStack.func_190926_b() || !this.oreMatches(storedStack, stack)) continue;
            return true;
        }
        return false;
    }

    private ItemStack convertOreDict(ItemStack incomingStack) {
        for (ItemStack storedStack : this.getStackList()) {
            if (!this.isOre(storedStack) || this.isOre(incomingStack) || !this.oreMatches(storedStack, incomingStack)) continue;
            ItemStack newStack = storedStack.func_77946_l();
            newStack.func_190920_e(incomingStack.func_190916_E());
            return newStack;
        }
        return incomingStack;
    }

    private boolean oreMatches(ItemStack storedStack, ItemStack incomingStack) {
        List<String> oreNamesForStoredStack = DankNullHandler.getOreNames(storedStack);
        List<String> oreNamesForIncomingStack = DankNullHandler.getOreNames(incomingStack);
        for (String currentStoredName : oreNamesForStoredStack) {
            if (!ModConfig.isValidOre(currentStoredName)) continue;
            for (String currentIncomingName : oreNamesForIncomingStack) {
                if (!ModConfig.isValidOre(currentIncomingName) || !currentIncomingName.equals(currentStoredName)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getOreNames(ItemStack stack) {
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
        if (oreIds.length > 0) {
            ArrayList<String> nameList = new ArrayList<String>();
            for (int oreId : oreIds) {
                String name = OreDictionary.getOreName((int)oreId);
                if (name.equals("Unknown") || !ModConfig.isValidOre(name)) continue;
                nameList.add(name);
            }
            return nameList;
        }
        return new ArrayList<String>();
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int extract;
        if (amount < 1) {
            return ItemStack.field_190927_a;
        }
        this.validateSlot(slot);
        ItemStack existing = (ItemStack)this.getStackList().get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int existingCount = existing.func_190916_E();
        if (existingCount <= (extract = Math.min(amount, existing.func_77976_d()))) {
            if (!simulate) {
                this.getStackList().set(slot, (Object)ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.getStackList().set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existingCount - extract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)extract);
    }

    @Override
    public boolean containsItemStack(@Nonnull ItemStack stack) {
        return this.findItemStack(stack) > -1;
    }

    @Override
    public int findItemStack(@Nonnull ItemStack stack) {
        for (int i = 0; i < this.getStackList().size(); ++i) {
            if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)((ItemStack)this.getStackList().get(i)), (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int stackCount() {
        int count = 0;
        for (ItemStack stack : this.getStackList()) {
            if (stack.func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    @Override
    @Nonnull
    public ModGlobals.DankNullTier getTier() {
        return this.tier;
    }

    @Override
    public void setSelected(int slot) {
        this.selected = slot;
        this.onSettingsChanged();
    }

    @Override
    public int getSelected() {
        return this.selected;
    }

    @Override
    public void cycleSelected(boolean forward) {
        int numBlockSlots;
        List<Integer> blockSlots = this.getBlockStacksSlots();
        if (ModConfig.Options.skipNonBlocksOnCycle && (numBlockSlots = blockSlots.size()) > 0) {
            if (blockSlots.size() == 1) {
                if (this.getSelected() != blockSlots.get(0).intValue()) {
                    this.setSelected(blockSlots.get(0));
                }
                return;
            }
            int current = this.getSelected();
            if (!blockSlots.contains(current)) {
                this.setSelected(blockSlots.get(0));
                return;
            }
            boolean min = false;
            int max = blockSlots.size() - 1;
            int currentIndex = this.getBlockSlotIndex(current);
            if (forward) {
                if (currentIndex != max) {
                    this.setSelected(blockSlots.get(currentIndex + 1));
                    return;
                }
                this.setSelected(blockSlots.get(0));
                return;
            }
            if (currentIndex != 0) {
                this.setSelected(blockSlots.get(currentIndex - 1));
                return;
            }
            this.setSelected(blockSlots.get(max));
            return;
        }
        int current = this.getSelected();
        int stackCount = this.stackCount();
        int newIndex = 0;
        if (stackCount > 1) {
            if (forward) {
                if (current != stackCount - 1) {
                    newIndex = current + 1;
                }
            } else {
                newIndex = current == 0 ? stackCount - 1 : current - 1;
            }
        }
        if (current != newIndex) {
            this.setSelected(newIndex);
        }
    }

    private int getBlockSlotIndex(int slot) {
        for (int i = 0; i < this.getBlockStacksSlots().size(); ++i) {
            if (this.getBlockStacksSlots().get(i) != slot) continue;
            return i;
        }
        return -1;
    }

    private List<Integer> getBlockStacksSlots() {
        ArrayList blockStackSlots = Lists.newArrayList();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack fullStack = this.getFullStackInSlot(i);
            if (fullStack.func_190926_b() || !(fullStack.func_77973_b() instanceof ItemBlock)) continue;
            blockStackSlots.add(i);
        }
        Collections.sort(blockStackSlots);
        return blockStackSlots;
    }

    @Override
    public void setLocked(boolean lock) {
        this.isLocked = lock;
        this.onSettingsChanged();
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public boolean isLockingSupported() {
        return this.tier.isCreative();
    }

    @Override
    public void setOre(@Nonnull ItemStack stack, boolean ore) {
        if (stack.func_190926_b()) {
            return;
        }
        for (ItemStack currentStack : this.oreStacks.keySet()) {
            if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)stack)) continue;
            this.oreStacks.put(currentStack, ore);
            this.onSettingsChanged();
            return;
        }
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        this.oreStacks.put(stack, ore);
        this.onSettingsChanged();
    }

    @Override
    public boolean isOre(@Nonnull ItemStack stack) {
        for (ItemStack currentStack : this.oreStacks.keySet()) {
            if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)stack)) continue;
            return this.oreStacks.get(currentStack);
        }
        return false;
    }

    @Override
    public boolean isOreSupported(@Nonnull ItemStack stack) {
        return OreDictionary.getOreIDs((ItemStack)stack).length > 0;
    }

    @Override
    @Nonnull
    public Map<ItemStack, Boolean> getOres() {
        return this.oreStacks;
    }

    @Override
    public void setExtractionMode(@Nonnull ItemStack stack, @Nonnull DankNullItemModes.ItemExtractionMode mode) {
        if (stack.func_190926_b()) {
            return;
        }
        for (ItemStack currentStack : this.extractionStacks.keySet()) {
            if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)stack)) continue;
            this.extractionStacks.put(currentStack, mode);
            this.onSettingsChanged();
            return;
        }
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        this.extractionStacks.put(stack, mode);
        this.onSettingsChanged();
    }

    @Override
    public void cycleExtractionMode(@Nonnull ItemStack stack, boolean forward) {
        DankNullItemModes.ItemExtractionMode current = this.getExtractionMode(stack);
        DankNullItemModes.ItemExtractionMode[] values = DankNullItemModes.ItemExtractionMode.values();
        current = forward ? (current.ordinal() == values.length - 1 ? values[0] : values[current.ordinal() + 1]) : (current.ordinal() == 0 ? values[values.length - 1] : values[current.ordinal() - 1]);
        this.setExtractionMode(stack, current);
    }

    @Override
    @Nonnull
    public DankNullItemModes.ItemExtractionMode getExtractionMode(@Nonnull ItemStack stack) {
        for (ItemStack currentStack : this.extractionStacks.keySet()) {
            if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)stack)) continue;
            return this.extractionStacks.get(currentStack);
        }
        return DankNullItemModes.ItemExtractionMode.KEEP_ALL;
    }

    @Override
    @Nonnull
    public Map<ItemStack, DankNullItemModes.ItemExtractionMode> getExtractionModes() {
        return this.extractionStacks;
    }

    @Override
    public void setPlacementMode(@Nonnull ItemStack stack, @Nonnull DankNullItemModes.ItemPlacementMode mode) {
        if (stack.func_190926_b()) {
            return;
        }
        for (ItemStack currentStack : this.placementStacks.keySet()) {
            if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)stack)) continue;
            this.placementStacks.put(currentStack, mode);
            this.onSettingsChanged();
            return;
        }
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        this.placementStacks.put(stack, mode);
        this.onSettingsChanged();
    }

    @Override
    public void cyclePlacementMode(@Nonnull ItemStack stack, boolean forward) {
        DankNullItemModes.ItemPlacementMode current = this.getPlacementMode(stack);
        DankNullItemModes.ItemPlacementMode[] values = DankNullItemModes.ItemPlacementMode.values();
        current = forward ? (current.ordinal() == values.length - 1 ? values[0] : values[current.ordinal() + 1]) : (current.ordinal() == 0 ? values[values.length - 1] : values[current.ordinal() - 1]);
        this.setPlacementMode(stack, current);
    }

    @Override
    @Nonnull
    public DankNullItemModes.ItemPlacementMode getPlacementMode(@Nonnull ItemStack stack) {
        for (ItemStack currentStack : this.placementStacks.keySet()) {
            if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)stack)) continue;
            return this.placementStacks.get(currentStack);
        }
        return DankNullItemModes.ItemPlacementMode.KEEP_1;
    }

    @Override
    public Map<ItemStack, DankNullItemModes.ItemPlacementMode> getPlacementMode() {
        return this.placementStacks;
    }

    public int getSlots() {
        return this.getStackList().size();
    }

    @Override
    public NonNullList<ItemStack> getStackList() {
        return this.stacks;
    }

    public int getSlotLimit(int slot) {
        return this.tier.getMaxStackSize();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        boolean isSame = ItemStack.func_179545_c((ItemStack)this.getFullStackInSlot(slot), (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)this.getFullStackInSlot(slot), (ItemStack)stack);
        return !(stack.func_77973_b() instanceof ItemDankNull) && (this.getFullStackInSlot(slot).func_190926_b() || isSame);
    }

    public void sort() {
        this.getStackList().sort((o1, o2) -> {
            if (o1.equals(o2)) {
                return 0;
            }
            if (o1.func_190926_b()) {
                return 1;
            }
            if (o2.func_190926_b()) {
                return -1;
            }
            return 0;
        });
    }

    public void updateSelectedSlot() {
        int selected = this.getSelected();
        if (selected >= 0 && !this.getFullStackInSlot(selected).func_190926_b()) {
            return;
        }
        int newSelected = -1;
        if (selected > 0) {
            for (int i = selected; i > -1; --i) {
                if (this.getFullStackInSlot(i).func_190926_b()) continue;
                newSelected = i;
                break;
            }
        } else if (!this.getFullStackInSlot(0).func_190926_b()) {
            newSelected = 0;
        }
        this.setSelected(newSelected);
    }

    protected void onContentsChanged(int slot) {
        this.sort();
        this.updateSelectedSlot();
    }

    protected void onSettingsChanged() {
    }
}

