/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.inventory.cap;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import p455w0rd.danknull.api.IDankNullHandler;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.inventory.DankNullHandler;
import p455w0rd.danknull.inventory.cap.CapabilityDankNull;
import p455w0rdslib.util.CapabilityUtils;

public class DankNullCapabilityProvider
implements ICapabilityProvider {
    private final ItemStack stack;
    private final IDankNullHandler dankNullHandler;
    private boolean needsInitialNBT = false;

    public DankNullCapabilityProvider(ModGlobals.DankNullTier tier, final ItemStack stack) {
        this.stack = stack;
        this.dankNullHandler = new DankNullHandler(tier){

            @Override
            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                NBTTagCompound oldNBT = stack.func_77978_p();
                NBTTagCompound newNBT = (NBTTagCompound)CapabilityDankNull.DANK_NULL_CAPABILITY.writeNBT((Object)this, null);
                if (oldNBT != null) {
                    if (newNBT != null) {
                        oldNBT.func_179237_a(newNBT);
                    }
                } else {
                    oldNBT = newNBT;
                }
                stack.func_77982_d(oldNBT);
            }

            @Override
            protected void onSettingsChanged() {
                super.onSettingsChanged();
                NBTTagCompound oldNBT = stack.func_77978_p();
                NBTTagCompound newNBT = (NBTTagCompound)CapabilityDankNull.DANK_NULL_CAPABILITY.writeNBT((Object)this, null);
                if (oldNBT != null) {
                    if (newNBT != null) {
                        oldNBT.func_179237_a(newNBT);
                    }
                } else {
                    oldNBT = newNBT;
                }
                stack.func_77982_d(oldNBT);
            }
        };
        if (stack.func_77942_o()) {
            CapabilityDankNull.DANK_NULL_CAPABILITY.readNBT((Object)this.dankNullHandler, null, (NBTBase)stack.func_77978_p());
        } else {
            this.needsInitialNBT = true;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.needsInitialNBT && this.stack.func_77942_o()) {
            this.needsInitialNBT = false;
            CapabilityDankNull.DANK_NULL_CAPABILITY.readNBT((Object)this.dankNullHandler, null, (NBTBase)this.stack.func_77978_p());
        }
        return capability == CapabilityDankNull.DANK_NULL_CAPABILITY || CapabilityUtils.isItemHandler(capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            if (CapabilityUtils.isItemHandler(capability)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.dankNullHandler);
            }
            if (capability == CapabilityDankNull.DANK_NULL_CAPABILITY) {
                return (T)CapabilityDankNull.DANK_NULL_CAPABILITY.cast((Object)this.dankNullHandler);
            }
        }
        return null;
    }
}

