/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import p455w0rd.danknull.api.DankNullItemModes;
import p455w0rd.danknull.api.IDankNullHandler;
import p455w0rd.danknull.client.render.DankNullRenderer;
import p455w0rd.danknull.init.ModConfig;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.init.ModGuiHandler;
import p455w0rd.danknull.integration.ExtraUtilities;
import p455w0rd.danknull.inventory.PlayerSlot;
import p455w0rd.danknull.inventory.cap.CapabilityDankNull;
import p455w0rd.danknull.inventory.cap.DankNullCapabilityProvider;
import p455w0rd.danknull.items.ItemBlockDankNullDock;
import p455w0rd.danknull.items.ItemDankNullPanel;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.api.client.ICustomItemRenderer;
import p455w0rdslib.api.client.IModelHolder;
import p455w0rdslib.api.client.ItemLayerWrapper;

public class ItemDankNull
extends Item
implements IModelHolder {
    private final ModGlobals.DankNullTier tier;
    @SideOnly(value=Side.CLIENT)
    private ItemLayerWrapper wrappedModel;

    public ItemDankNull(ModGlobals.DankNullTier tier) {
        this.tier = tier;
        this.setRegistryName(tier.getDankNullRegistryName());
        this.func_77655_b(tier.getUnlocalizedNameForDankNull());
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"dn.number_of_slots.desc", (Object[])new Object[0]) + ": " + ItemDankNull.getTier(stack).getNumRows() * 9);
        String maxMsg = ItemDankNull.getTier(stack) == ModGlobals.DankNullTier.CREATIVE ? "" + TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"dn.infinite.desc", (Object[])new Object[0]) + TextFormatting.GRAY : "" + ItemDankNull.getTier(stack).getMaxStackSize();
        tooltip.add(maxMsg + " " + I18n.func_135052_a((String)"dn.items_per_slot.desc", (Object[])new Object[0]));
    }

    public static List<PlayerSlot> getDankNullsForPlayer(EntityPlayer player) {
        int i;
        InventoryPlayer playerInv = player.field_71071_by;
        ArrayList dankNullList = Lists.newArrayList();
        for (i = 0; i < playerInv.field_70462_a.size(); ++i) {
            if (!ItemDankNull.isDankNull((ItemStack)playerInv.field_70462_a.get(i))) continue;
            dankNullList.add(new PlayerSlot(i, PlayerSlot.EnumInvCategory.MAIN));
        }
        for (i = 0; i < playerInv.field_184439_c.size(); ++i) {
            if (!ItemDankNull.isDankNull((ItemStack)playerInv.field_184439_c.get(i))) continue;
            dankNullList.add(new PlayerSlot(i, PlayerSlot.EnumInvCategory.OFF_HAND));
        }
        return dankNullList;
    }

    public static ModGlobals.DankNullTier getTier(ItemStack dankNull) {
        int meta = -1;
        if (ItemDankNull.isDankNull(dankNull)) {
            meta = ((ItemDankNull)dankNull.func_77973_b()).getTier().ordinal();
        } else if (ItemDankNullPanel.isDankNullPanel(dankNull)) {
            meta = ((ItemDankNullPanel)dankNull.func_77973_b()).getTier().ordinal();
        } else if (ItemBlockDankNullDock.isDankNullDock(dankNull)) {
            ItemStack dockedDank = ItemBlockDankNullDock.getDockedDankNull(dankNull);
            boolean isEmpty = ItemBlockDankNullDock.isDankNullDock(dankNull) && dockedDank.func_190926_b();
            meta = !isEmpty ? ((ItemDankNull)dockedDank.func_77973_b()).getTier().ordinal() : -1;
        }
        return meta == -1 ? ModGlobals.DankNullTier.NONE : ModGlobals.DankNullTier.VALUES[meta];
    }

    public static boolean isDankNull(ItemStack stack) {
        return !stack.func_190926_b() && stack.hasCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null);
    }

    public ModGlobals.DankNullTier getTier() {
        return this.tier;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new DankNullCapabilityProvider(this.tier, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)this.getModelResource(this));
    }

    @SideOnly(value=Side.CLIENT)
    public ItemLayerWrapper getWrappedModel() {
        return this.wrappedModel;
    }

    @SideOnly(value=Side.CLIENT)
    public void setWrappedModel(ItemLayerWrapper wrappedModel) {
        this.wrappedModel = wrappedModel;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldUseInternalTEISR() {
        return true;
    }

    public ICustomItemRenderer getRenderer() {
        return DankNullRenderer.getRendererForItem(this);
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        if (ModConfig.Options.callItDevNull) {
            name = name.replace("/dank/", "/dev/");
        }
        return name;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && this.getBlockUnderPlayer(player) != Blocks.field_150350_a && !world.field_72995_K) {
            ModGuiHandler.launchGui(ModGuiHandler.GUIType.DANKNULL, player, world, player.func_180425_c(), new PlayerSlot(player.field_71071_by.field_70461_c, PlayerSlot.EnumInvCategory.MAIN));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (LibGlobals.Mods.EXTRA_UTILITIES_2.isLoaded() && ExtraUtilities.isAngelBlockSelected(stack)) {
            if (!world.field_72995_K) {
                return ExtraUtilities.tryPlaceAngelBlock(stack, player, hand);
            }
            player.func_184609_a(hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean func_77645_m() {
        return false;
    }

    private IBlockState getBlockUnderPlayer(EntityPlayer player) {
        int blockX = MathHelper.func_76128_c((double)player.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)(player.func_174813_aQ().field_72338_b - 0.5));
        int blockZ = MathHelper.func_76128_c((double)player.field_70161_v);
        return player.func_130014_f_().func_180495_p(new BlockPos(blockX, blockY, blockZ));
    }

    public RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos posIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        PlayerSlot playerSlot = new PlayerSlot(player.field_71071_by.field_70461_c, hand == EnumHand.MAIN_HAND ? PlayerSlot.EnumInvCategory.MAIN : PlayerSlot.EnumInvCategory.OFF_HAND);
        IDankNullHandler dankNullHandler = (IDankNullHandler)stack.getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null);
        ItemStack selectedStack = dankNullHandler.getSelected() > -1 ? dankNullHandler.getFullStackInSlot(dankNullHandler.getSelected()) : ItemStack.field_190927_a;
        Block selectedBlock = Block.func_149634_a((Item)selectedStack.func_77973_b());
        boolean isSelectedStackABlock = selectedBlock != null && selectedBlock != Blocks.field_150350_a;
        Block blockUnderPlayer = this.getBlockUnderPlayer(player).func_177230_c();
        if (player.func_70093_af() && blockUnderPlayer != Blocks.field_150350_a && isSelectedStackABlock && blockUnderPlayer != selectedBlock) {
            ModGuiHandler.launchGui(ModGuiHandler.GUIType.DANKNULL, player, world, player.func_180425_c(), playerSlot);
            return EnumActionResult.SUCCESS;
        }
        DankNullItemModes.ItemPlacementMode placementMode = dankNullHandler.getPlacementMode(selectedStack);
        if (placementMode.getNumberToKeep() >= selectedStack.func_190916_E() && !player.field_71075_bZ.field_75098_d || selectedStack.func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(posIn);
        Block block = state.func_177230_c();
        BlockPos placePosition = posIn;
        if (this.isBucket(selectedStack)) {
            if (this.tryUseBucket(world, player, selectedStack) == EnumActionResult.SUCCESS) {
                dankNullHandler.extractItem(dankNullHandler.getSelected(), 1, player.field_71075_bZ.field_75098_d);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        if (!block.func_176200_f((IBlockAccess)world, placePosition)) {
            placePosition = placePosition.func_177972_a(facing);
        }
        if (!player.func_175151_a(placePosition, facing, selectedStack) || !world.func_190527_a(selectedBlock, placePosition, false, facing, (Entity)player) || dankNullHandler.extractItem(dankNullHandler.getSelected(), 1, true).func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        if (selectedStack.func_77973_b() instanceof ItemBlock) {
            int i = selectedStack.func_77973_b().func_77647_b(selectedStack.func_77960_j());
            IBlockState iblockstate1 = selectedBlock.getStateForPlacement(world, placePosition, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (((ItemBlock)selectedStack.func_77973_b()).placeBlockAt(selectedStack, player, world, placePosition, facing, hitX, hitY, hitZ, iblockstate1)) {
                iblockstate1 = world.func_180495_p(placePosition);
                SoundType soundtype = iblockstate1.func_177230_c().getSoundType(iblockstate1, world, placePosition, (Entity)player);
                world.func_184133_a(player, placePosition, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                dankNullHandler.extractItem(dankNullHandler.getSelected(), 1, player.field_71075_bZ.field_75098_d);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private boolean isBucket(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151131_as || stack.func_77973_b() == Items.field_151129_at || stack.func_77973_b() instanceof UniversalBucket;
    }

    @Nonnull
    public EnumActionResult tryUseBucket(@Nonnull World world, @Nonnull EntityPlayer player, ItemStack bucket) {
        if (!this.isBucket(bucket)) {
            return EnumActionResult.FAIL;
        }
        FluidStack fluidStack = this.getFluid(bucket);
        if (fluidStack == null) {
            return EnumActionResult.PASS;
        }
        RayTraceResult mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return EnumActionResult.PASS;
        }
        BlockPos clickPos = mop.func_178782_a();
        if (FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)clickPos.func_177972_a((EnumFacing)mop.field_178784_b), (ItemStack)bucket.func_77946_l(), (FluidStack)FluidUtil.getFluidContained((ItemStack)bucket)).success) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Items.field_151133_ar));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private FluidStack getFluid(ItemStack stack) {
        if (this.isBucket(stack)) {
            return ((IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).getTankProperties()[0].getContents();
        }
        return null;
    }

    public static EnumActionResult placeBlock(@Nonnull IBlockState state, World world, BlockPos pos) {
        return world.func_180501_a(pos, state, 2) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public EnumActionResult placeItemIntoWorld(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        return this.placeItemIntoWorld(itemstack, player, world, pos, facing, hitX, hitY, hitZ, hand, false);
    }

    public EnumActionResult placeItemIntoWorld(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand, boolean skipSlab) {
        if (itemstack.func_77973_b() instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
            ItemSlab slab = null;
            if (itemstack.func_77973_b() instanceof ItemSlab && !skipSlab) {
                slab = (ItemSlab)itemstack.func_77973_b();
            }
            if (slab != null) {
                return this.placeSlab(player, world, pos.func_177972_a(facing.func_176734_d()), hand, facing, hitX, hitY, hitZ, itemstack, slab);
            }
            if (!block.func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(facing);
            }
            if (!itemstack.func_190926_b() && player.func_175151_a(pos, facing, itemstack) && world.func_190527_a(block, pos, false, facing, (Entity)null)) {
                IBlockState iblockstate1 = block.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, itemstack.func_77952_i(), (EntityLivingBase)player, hand);
                if (this.placeBlockAt(itemstack, player, world, pos, facing, hitX, hitY, hitZ, iblockstate1, block)) {
                    iblockstate1 = world.func_180495_p(pos);
                    SoundType soundtype = iblockstate1.func_177230_c().getSoundType(iblockstate1, world, pos, (Entity)player);
                    world.func_184133_a((EntityPlayer)null, player.func_180425_c(), soundtype.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 2.0f));
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState, Block block) {
        ItemStack tmpStack = stack.func_77946_l();
        tmpStack.func_190920_e(1);
        if (tmpStack.func_77973_b() instanceof ItemBlock) {
            ItemBlock blockItem = (ItemBlock)tmpStack.func_77973_b();
            blockItem.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
            return true;
        }
        world.func_180501_a(pos, newState, 3);
        world.func_175685_c(pos, block, true);
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, tmpStack);
        }
        return true;
    }

    public EnumActionResult placeSlab(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ, ItemStack itemstack, ItemSlab slab) {
        BlockSlab singleSlab = slab.field_150949_c;
        if (!itemstack.func_190926_b() && player.func_175151_a(pos, facing, itemstack)) {
            Comparable comparable = singleSlab.func_185674_a(itemstack);
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            ItemStack blockAsStack = new ItemStack(Item.func_150898_a((Block)iblockstate.func_177230_c()), 1, iblockstate.func_177230_c().func_176201_c(iblockstate));
            if (iblockstate.func_177230_c() == singleSlab && ((BlockSlab)iblockstate.func_177230_c()).func_185674_a(blockAsStack) == comparable) {
                IProperty iproperty = singleSlab.func_176551_l();
                Comparable comparable1 = iblockstate.func_177229_b(iproperty);
                BlockSlab.EnumBlockHalf blockslab$enumblockhalf = (BlockSlab.EnumBlockHalf)iblockstate.func_177229_b((IProperty)BlockSlab.field_176554_a);
                if ((facing == EnumFacing.UP && blockslab$enumblockhalf == BlockSlab.EnumBlockHalf.BOTTOM || facing == EnumFacing.DOWN && blockslab$enumblockhalf == BlockSlab.EnumBlockHalf.TOP) && comparable1 == comparable) {
                    IBlockState iblockstate1 = this.makeState(iproperty, comparable1, slab);
                    AxisAlignedBB axisalignedbb = iblockstate1.func_185890_d((IBlockAccess)worldIn, pos);
                    if (axisalignedbb != Block.field_185506_k && worldIn.func_72855_b(axisalignedbb.func_186670_a(pos)) && worldIn.func_180501_a(pos, iblockstate1, 3)) {
                        SoundType soundtype = singleSlab.getSoundType(iblockstate1, worldIn, pos, (Entity)player);
                        worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                        if (player instanceof EntityPlayerMP) {
                            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, itemstack);
                        }
                    }
                    return this.tryPlace(player, itemstack, worldIn, pos, comparable, slab) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
                }
                return this.tryPlace(player, itemstack, worldIn, pos.func_177972_a(facing), comparable, slab) ? EnumActionResult.SUCCESS : this.placeItemIntoWorld(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, hand, true);
            }
            return this.tryPlace(player, itemstack, worldIn, pos.func_177972_a(facing), comparable, slab) ? EnumActionResult.SUCCESS : this.placeItemIntoWorld(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, hand, true);
        }
        return EnumActionResult.FAIL;
    }

    private boolean tryPlace(EntityPlayer player, ItemStack stack, World worldIn, BlockPos pos, Object itemSlabType, ItemSlab slab) {
        BlockSlab singleSlab = slab.field_150949_c;
        BlockSlab doubleSlab = slab.field_179226_c;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() == singleSlab) {
            Comparable comparable = singleSlab.func_185674_a(stack);
            ItemStack blockAsStack = new ItemStack(Item.func_150898_a((Block)iblockstate.func_177230_c()), 1, iblockstate.func_177230_c().func_176201_c(iblockstate));
            if (comparable == itemSlabType && ((BlockSlab)iblockstate.func_177230_c()).func_185674_a(blockAsStack) == comparable) {
                IBlockState iblockstate1 = this.makeState(singleSlab.func_176551_l(), comparable, slab);
                AxisAlignedBB axisalignedbb = iblockstate1.func_185890_d((IBlockAccess)worldIn, pos);
                if (axisalignedbb != Block.field_185506_k && worldIn.func_72855_b(axisalignedbb.func_186670_a(pos)) && worldIn.func_180501_a(pos, iblockstate1, 3)) {
                    SoundType soundtype = doubleSlab.getSoundType(iblockstate1, worldIn, pos, (Entity)player);
                    worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                }
                return true;
            }
        }
        return false;
    }

    protected <T extends Comparable<T>> IBlockState makeState(IProperty<T> p_185055_1_, Comparable<?> p_185055_2_, ItemSlab slab) {
        BlockSlab doubleSlab = slab.field_179226_c;
        return doubleSlab.func_176223_P().func_177226_a(p_185055_1_, p_185055_2_);
    }

    @Nullable
    public FontRenderer getFontRenderer(ItemStack p_getFontRenderer_1_) {
        return super.getFontRenderer(p_getFontRenderer_1_);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.tier.getRarity();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.func_77969_a(newStack) || slotChanged;
    }
}

