/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.ModBlocks;
import doggytalents.entity.EntityDog;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAISitOnBed
extends EntityAIBase {
    private final EntityDog dog;
    private final double movementSpeed;
    protected int runDelay;
    private int timeoutCounter;
    private int maxStayTicks;
    protected BlockPos destinationBlock = BlockPos.field_177992_a;
    private boolean isAboveDestination;
    private final int searchLength;

    public EntityAISitOnBed(EntityDog dogIn, double speedIn) {
        this.dog = dogIn;
        this.movementSpeed = speedIn;
        this.searchLength = 8;
        this.func_75248_a(5);
    }

    public boolean func_75250_a() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        if (!this.dog.func_70909_n()) {
            return false;
        }
        if (this.dog.func_70906_o()) {
            return false;
        }
        return this.searchForDestination() && !this.isOtherDogSitting();
    }

    public boolean func_75253_b() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.shouldMoveTo(this.dog.field_70170_p, this.destinationBlock) && !this.isOtherDogSitting();
    }

    public void func_75249_e() {
        this.dog.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.dog.func_70681_au().nextInt(this.dog.func_70681_au().nextInt(1200) + 1200) + 1200;
        this.dog.func_70907_r().func_75270_a(false);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.runDelay = 200 + this.dog.func_70681_au().nextInt(200);
        this.dog.func_70904_g(false);
    }

    public void func_75246_d() {
        if (this.dog.func_174831_c(this.destinationBlock) > 1.0) {
            this.isAboveDestination = false;
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.dog.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
            }
        } else {
            this.isAboveDestination = true;
            --this.timeoutCounter;
        }
        this.dog.func_70907_r().func_75270_a(false);
        if (!this.getIsAboveDestination()) {
            this.dog.func_70904_g(false);
        } else if (!this.dog.func_70906_o()) {
            this.dog.func_70904_g(true);
        }
    }

    protected boolean getIsAboveDestination() {
        return this.isAboveDestination;
    }

    private boolean searchForDestination() {
        int i = this.searchLength;
        boolean j = true;
        BlockPos blockpos = new BlockPos((Entity)this.dog);
        int k = 0;
        while (k <= 1) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        BlockPos blockpos1 = blockpos.func_177982_a(i1, k - 1, j1);
                        if (this.dog.func_180485_d(blockpos1) && this.shouldMoveTo(this.dog.field_70170_p, blockpos1)) {
                            this.destinationBlock = blockpos1;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    private boolean isOtherDogSitting() {
        for (EntityDog otherDog : this.dog.field_70170_p.func_72872_a(EntityDog.class, new AxisAlignedBB(this.destinationBlock).func_186662_g(2.0))) {
            if (otherDog == this.dog || !otherDog.isLyingDown()) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        IBlockState blockstate = worldIn.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        return block == ModBlocks.DOG_BED;
    }
}

