/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items.unique;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.entities.projectiles.DTEntityGoldNugget;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.items.DTPotshot;

public class DTCoinCannon
extends DTPotshot {
    public DTCoinCannon(String name) {
        super(name);
        this.func_77656_e(1000);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity == null) {
                    return 0.0f;
                }
                return entity.func_184607_cu().func_77973_b() != DTItems.COIN_CANNON ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public String func_77653_i(ItemStack stack) {
        return TextFormatting.DARK_AQUA + super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return material.func_77969_a(new ItemStack(Items.field_151062_by)) || super.func_82789_a(stack, material);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        boolean flag1 = !this.hasAmmo(player).func_190926_b();
        boolean flag2 = player.field_71075_bZ.field_75098_d;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)player.func_184586_b(hand), (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)flag1);
        if (ret != null) {
            return ret;
        }
        if (!flag2 && !flag1) {
            return !flag1 ? new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand)) : new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        this.fireTheCannon(stack, world, entityLiving, 0);
        return stack;
    }

    @Override
    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        this.fireTheCannon(stack, world, entityLiving, timeLeft);
    }

    private ItemStack hasAmmo(EntityPlayer player) {
        if (this.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected boolean isAmmo(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() == Items.field_151074_bl && stack.func_190916_E() >= 3 || stack.func_77973_b() == Items.field_151043_k || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150340_R));
    }

    public static float getProjectileVelocity(int charge) {
        float f = (float)charge / 5.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void fireTheCannon(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ItemStack ammoType = this.hasAmmo(player);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (!ammoType.func_190926_b() || player.field_71075_bZ.field_75098_d ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoType.func_190926_b() || player.field_71075_bZ.field_75098_d) {
                if (ammoType.func_190926_b()) {
                    ammoType = new ItemStack(Items.field_151074_bl);
                }
                int count = this.calcAmmo(ammoType, player, ammoType.func_190916_E());
                float f = DTCoinCannon.getProjectileVelocity(i);
                if ((double)f >= 0.1) {
                    if (!world.field_72995_K) {
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        float yaw = player.field_70177_z;
                        float pitch = player.field_70125_A;
                        float f1 = -0.1f;
                        double motionX = -MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * f1;
                        double motionZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * f1;
                        for (i = 0; i < count; ++i) {
                            DTEntityGoldNugget bullet = new DTEntityGoldNugget(world, (EntityLivingBase)player);
                            bullet.knockbackStrength = 1;
                            bullet.coinCannon = true;
                            bullet.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 0.6f, count / 3);
                            world.func_72838_d((Entity)bullet);
                        }
                        player.field_70159_w = motionX;
                        player.field_70179_y = motionZ;
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)player)));
                    }
                    world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187715_dR, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 8);
                    }
                }
            }
        }
    }

    public int calcAmmo(ItemStack stack, EntityPlayer player, int count) {
        ItemStack ingot;
        boolean flag = player.func_184812_l_();
        if (flag) {
            return 64;
        }
        if (stack.func_77973_b() == Items.field_151074_bl) {
            if (!flag) {
                stack.func_190918_g(count);
                if (stack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(stack);
                }
            }
            return count;
        }
        if (!flag) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_184437_d(stack);
            }
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150340_R) && !flag && !player.field_71071_by.func_70441_a(ingot = new ItemStack(Items.field_151043_k, 8))) {
            player.func_70099_a(ingot, player.eyeHeight);
        }
        return 9;
    }
}

