/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui.handbook;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.client.gui.handbook.Contents;
import electroblob.wizardry.client.gui.handbook.CraftingRecipe;
import electroblob.wizardry.client.gui.handbook.GuiButtonHyperlink;
import electroblob.wizardry.client.gui.handbook.GuiWizardHandbook;
import electroblob.wizardry.client.gui.handbook.HandbookToast;
import electroblob.wizardry.client.gui.handbook.Image;
import electroblob.wizardry.util.JavaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

class Section {
    String title;
    private String[] rawText;
    private Contents contents;
    private ResourceLocation[] triggers;
    private Map<String, Section> subsections;
    private boolean centreX;
    private boolean centreY;
    int startPage;
    private final List<List<GuiButton>> buttons = new ArrayList<List<GuiButton>>();
    private final List<List<String>> pages = new ArrayList<List<String>>();
    private boolean unlocked = false;
    private boolean isNew = false;

    private Section() {
        this.subsections = new LinkedHashMap<String, Section>();
    }

    Collection<GuiButton> getButtons() {
        return JavaUtils.flatten(this.buttons);
    }

    boolean containsPage(int page) {
        return this.isUnlocked() && this.startPage <= page && this.startPage + this.pages.size() > page;
    }

    boolean isUnlocked() {
        if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            return true;
        }
        if (!Wizardry.settings.handbookProgression) {
            return true;
        }
        if (this.triggers == null) {
            return true;
        }
        for (Section subsection : this.subsections.values()) {
            if (!subsection.isUnlocked()) continue;
            return true;
        }
        return this.unlocked;
    }

    boolean isNew() {
        if (!Wizardry.settings.handbookProgression) {
            return false;
        }
        return this.isNew || this.subsections.values().stream().anyMatch(Section::isNew);
    }

    void draw(FontRenderer font, int doublePage, int left, int top) {
        int[] visiblePages;
        int i = 0;
        for (List<GuiButton> list : this.buttons) {
            int i1 = i++;
            list.forEach(b -> {
                b.field_146125_m = GuiWizardHandbook.singleToDoublePage(this.startPage + i1) == doublePage;
            });
        }
        int leftIndex = GuiWizardHandbook.doubleToSinglePage(doublePage, false);
        for (int page : visiblePages = new int[]{leftIndex - this.startPage, leftIndex - this.startPage + 1}) {
            if (page < 0 || page >= this.pages.size()) continue;
            List<String> lines = this.pages.get(page);
            int x = left + (GuiWizardHandbook.isRightPage(this.startPage + page) ? 151 : 17);
            int y = top + 16;
            if (this.centreY) {
                y += 70 - lines.size() / 2 * font.field_78288_b;
            }
            for (String line : lines) {
                if (line.startsWith("#ruler")) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiWizardHandbook.texture);
                    DrawingUtils.drawTexturedRect(x - 1, y - 1, 0, 180, 122, 9, 512, 256);
                } else {
                    int lx = this.centreX ? x + 60 - font.func_78256_a(line) / 2 : x;
                    font.func_175065_a(line, (float)lx, (float)y, 1, false);
                }
                y += font.field_78288_b;
            }
            this.isNew = false;
        }
    }

    int format(FontRenderer font, int startPage, int left, int top) {
        this.buttons.clear();
        this.pages.clear();
        int maxLineNumber = 140 / font.field_78288_b;
        this.startPage = startPage;
        ArrayList<String> lines = new ArrayList<String>();
        if (!this.title.isEmpty()) {
            lines.add(this.title);
            lines.add("#ruler");
        }
        if (this.contents != null) {
            lines.addAll(Collections.nCopies(this.contents.format(font, startPage, lines.size(), left, top), ""));
            if (lines.size() % maxLineNumber != 0) {
                lines.add("");
            }
        }
        if (this.rawText != null) {
            String[] stringArray = this.rawText;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                int page;
                String paragraph;
                String raw = paragraph = stringArray[i];
                if (paragraph.startsWith("#image")) {
                    String[] arguments = paragraph.split("\\s", 2);
                    if (arguments.length < 2) {
                        throw new JsonSyntaxException("Missing image name in string " + StringUtils.abbreviate((String)raw, (int)50));
                    }
                    Image image = GuiWizardHandbook.images.get(arguments[1]);
                    if (image == null) {
                        throw new JsonSyntaxException("Image with id " + arguments[1] + " is undefined");
                    }
                    if (lines.size() % maxLineNumber * font.field_78288_b + image.getHeight(font) > 140) {
                        lines.addAll(Collections.nCopies(maxLineNumber - lines.size() % maxLineNumber, ""));
                    }
                    if (image.getWidth() > 120) {
                        Wizardry.logger.warn("Image with id " + arguments[1] + "has a width (" + image.getWidth() + ") greater than the maximum page width (" + 120 + "), it will extend beyond the page area.");
                    }
                    if (image.getHeight(font) > 140) {
                        Wizardry.logger.warn("Image with id " + arguments[1] + "has a height (" + image.getHeight(font) + ") greater than the maximum page height (" + 140 + "), it will extend beyond the page area.");
                    }
                    page = startPage + lines.size() / maxLineNumber;
                    image.addInstance(page, 60 - image.getWidth() / 2 + (GuiWizardHandbook.isRightPage(page) ? 151 : 17), 16 + lines.size() % maxLineNumber * font.field_78288_b);
                    lines.addAll(Collections.nCopies(image.getHeight(font) / font.field_78288_b, " "));
                    lines.add("");
                } else if (paragraph.startsWith("#recipe")) {
                    String[] arguments = paragraph.split("\\s", 2);
                    if (arguments.length < 2) {
                        throw new JsonSyntaxException("Missing recipe name in string " + StringUtils.abbreviate((String)raw, (int)50));
                    }
                    CraftingRecipe recipe = GuiWizardHandbook.recipes.get(arguments[1]);
                    if (recipe == null) {
                        throw new JsonSyntaxException("Recipe with id " + arguments[1] + " is undefined");
                    }
                    if (lines.size() % maxLineNumber * font.field_78288_b + 66 > 140) {
                        lines.addAll(Collections.nCopies(maxLineNumber - lines.size() % maxLineNumber, " "));
                    }
                    page = startPage + lines.size() / maxLineNumber;
                    if (lines.size() % maxLineNumber == 0) {
                        lines.add(" ");
                    }
                    int startLine = lines.size() % maxLineNumber - 1;
                    recipe.addInstance(page, 0 + (GuiWizardHandbook.isRightPage(page) ? 151 : 17), 16 + startLine * font.field_78288_b);
                    lines.addAll(Collections.nCopies(66 / font.field_78288_b - 1, " "));
                } else {
                    int linkStart;
                    for (Map.Entry<String, String> entry : GuiWizardHandbook.FORMAT_TAGS.entrySet()) {
                        paragraph = paragraph.replace('#' + entry.getKey(), entry.getValue());
                    }
                    while ((linkStart = paragraph.indexOf(64)) > -1) {
                        int linkEnd = paragraph.indexOf(64, linkStart + 1);
                        if (linkEnd < 0) {
                            throw new JsonSyntaxException("Un-closed hyperlink marker in string " + StringUtils.abbreviate((String)raw, (int)50));
                        }
                        List upToLink = font.func_78271_c(paragraph.substring(0, linkStart), 120);
                        String linkRaw = paragraph.substring(linkStart, linkEnd + 1);
                        String[] arguments = paragraph.substring(linkStart + 1, linkEnd).split("\\s", 2);
                        String suffix = paragraph.substring(linkEnd).split("\\s", 2)[0].substring(1);
                        int pageRelative = (lines.size() + upToLink.size() - 1) / maxLineNumber;
                        int page2 = startPage + pageRelative;
                        int lineNumber = (lines.size() + upToLink.size() - 1) % maxLineNumber;
                        int x = GuiWizardHandbook.isRightPage(page2) ? left + 288 - 17 - 120 : left + 17;
                        int y = top + 16 + lineNumber * font.field_78288_b;
                        while (this.buttons.size() <= pageRelative) {
                            this.buttons.add(new ArrayList());
                        }
                        this.buttons.get(pageRelative).add(GuiButtonHyperlink.create(x, y, font, upToLink, arguments, suffix, maxLineNumber - lineNumber - 1, GuiWizardHandbook.isRightPage(page2)));
                        paragraph = paragraph.replace(linkRaw, arguments[arguments.length - 1]);
                    }
                    lines.addAll(font.func_78271_c(paragraph, 120));
                }
                if (lines.size() % maxLineNumber == 0) continue;
                lines.add("");
            }
        }
        ArrayList<String> page = new ArrayList<String>();
        this.pages.add(page);
        while (!lines.isEmpty()) {
            if (page.size() == maxLineNumber) {
                while (((String)page.get(page.size() - 1)).isEmpty()) {
                    page.remove(page.size() - 1);
                }
                page = new ArrayList();
                this.pages.add(page);
            }
            String line = (String)lines.remove(0);
            if (page.isEmpty() && line.isEmpty()) continue;
            page.add(line);
        }
        return startPage + this.pages.size();
    }

    static Section fromJson(JsonObject json) {
        Section section = new Section();
        section.title = JsonUtils.func_151219_a((JsonObject)json, (String)"title", (String)"");
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"include_in_contents")) {
            String id = JsonUtils.func_151200_h((JsonObject)json, (String)"include_in_contents");
            Contents belongsTo = GuiWizardHandbook.contentsList.get(id);
            if (belongsTo == null) {
                throw new JsonSyntaxException("Expected include_in_contents to be the id of a previously defined contents, but no contents with the id " + id + " exists yet.");
            }
            belongsTo.addEntry(section);
        }
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"contents")) {
            section.contents = Contents.fromJson(section, JsonUtils.func_152754_s((JsonObject)json, (String)"contents"));
            GuiWizardHandbook.contentsList.put(section.contents.id, section.contents);
        }
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"text")) {
            section.rawText = (String[])Streams.stream((Iterable)JsonUtils.func_151214_t((JsonObject)json, (String)"text")).map(e -> JsonUtils.func_151206_a((JsonElement)e, (String)"element of array text")).toArray(String[]::new);
        }
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"triggers")) {
            section.triggers = (ResourceLocation[])Streams.stream((Iterable)JsonUtils.func_151214_t((JsonObject)json, (String)"triggers")).map(e -> new ResourceLocation(JsonUtils.func_151206_a((JsonElement)e, (String)"element of array triggers"))).toArray(ResourceLocation[]::new);
        }
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"centre")) {
            JsonObject centre = JsonUtils.func_152754_s((JsonObject)json, (String)"centre");
            section.centreX = JsonUtils.func_151209_a((JsonObject)centre, (String)"x", (boolean)false);
            section.centreY = JsonUtils.func_151209_a((JsonObject)centre, (String)"y", (boolean)false);
        }
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"sections")) {
            Section.populate(section.subsections, json);
        }
        return section;
    }

    static void populate(Map<String, Section> map, JsonObject json) {
        JsonObject sectionsObject = JsonUtils.func_152754_s((JsonObject)json, (String)"sections");
        for (Map.Entry entry : sectionsObject.entrySet()) {
            String key = (String)entry.getKey();
            Section section = Section.fromJson(((JsonElement)entry.getValue()).getAsJsonObject());
            map.put(key, section);
            map.putAll(section.subsections);
        }
    }

    public void updateUnlockStatus(boolean showToasts, ResourceLocation ... completedAdvancements) {
        if (this.triggers == null) {
            return;
        }
        ArrayList<ResourceLocation> completed = new ArrayList<ResourceLocation>(Arrays.asList(completedAdvancements));
        completed.retainAll(Arrays.asList(this.triggers));
        if (!this.unlocked && !completed.isEmpty() && showToasts && Wizardry.settings.handbookProgression) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_193033_an().func_192988_a((IToast)new HandbookToast(this));
            this.isNew = true;
        }
        this.unlocked = !completed.isEmpty();
    }
}

