/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.constants;

import electroblob.wizardry.Wizardry;
import java.util.Random;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public enum Tier {
    NOVICE(700, 3, 12, new Style().func_150238_a(TextFormatting.WHITE), "novice"),
    APPRENTICE(1000, 5, 5, new Style().func_150238_a(TextFormatting.AQUA), "apprentice"),
    ADVANCED(1500, 7, 2, new Style().func_150238_a(TextFormatting.DARK_BLUE), "advanced"),
    MASTER(2500, 9, 1, new Style().func_150238_a(TextFormatting.DARK_PURPLE), "master");

    public final int maxCharge;
    public final int level;
    public final int upgradeLimit;
    public final int weight;
    private final Style colour;
    private final String unlocalisedName;

    private Tier(int maxCharge, int upgradeLimit, int weight, Style colour, String name) {
        this.maxCharge = maxCharge;
        this.level = this.ordinal();
        this.upgradeLimit = upgradeLimit;
        this.weight = weight;
        this.colour = colour;
        this.unlocalisedName = name;
    }

    public static Tier fromName(String name) {
        for (Tier tier : Tier.values()) {
            if (!tier.unlocalisedName.equals(name)) continue;
            return tier;
        }
        throw new IllegalArgumentException("No such tier with unlocalised name: " + name);
    }

    public Tier next() {
        return this.ordinal() + 1 < Tier.values().length ? Tier.values()[this.ordinal() + 1] : this;
    }

    public Tier previous() {
        return this.ordinal() > 0 ? Tier.values()[this.ordinal() - 1] : this;
    }

    public String getDisplayName() {
        return Wizardry.proxy.translate("tier." + this.unlocalisedName, new Object[0]);
    }

    public TextComponentTranslation getNameForTranslation() {
        return new TextComponentTranslation("tier." + this.unlocalisedName, new Object[0]);
    }

    public String getDisplayNameWithFormatting() {
        return Wizardry.proxy.translate("tier." + this.unlocalisedName, this.colour, new Object[0]);
    }

    public ITextComponent getNameForTranslationFormatted() {
        return new TextComponentTranslation("tier." + this.unlocalisedName, new Object[0]).func_150255_a(this.colour);
    }

    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    public String getFormattingCode() {
        return this.colour.func_150218_j();
    }

    public int getProgression() {
        return Wizardry.settings.progressionRequirements[this.ordinal() - 1];
    }

    public static Tier getWeightedRandomTier(Random random, Tier ... tiers) {
        if (tiers.length == 0) {
            tiers = Tier.values();
        }
        int totalWeight = 0;
        for (Tier tier : tiers) {
            totalWeight += tier.weight;
        }
        int randomiser = random.nextInt(totalWeight);
        int cumulativeWeight = 0;
        for (Tier tier : tiers) {
            if (randomiser >= (cumulativeWeight += tier.weight)) continue;
            return tier;
        }
        return tiers[tiers.length - 1];
    }
}

