/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.NBTExtras;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityLevitatingBlock
extends EntityFallingBlock
implements IEntityAdditionalSpawnData {
    private static final Field fallTile = ObfuscationReflectionHelper.findField(EntityFallingBlock.class, (String)"field_175132_d");
    private WeakReference<EntityLivingBase> caster;
    private UUID casterUUID;
    public float damageMultiplier = 1.0f;
    private int suspendTimer = 5;

    public EntityLevitatingBlock(World world) {
        super(world);
        this.func_70105_a(0.98f, 0.98f);
    }

    public EntityLevitatingBlock(World world, double x, double y, double z, IBlockState state) {
        super(world, x, y, z, state);
    }

    public void suspend() {
        this.suspendTimer = 5;
    }

    public void func_70071_h_() {
        double velocitySquared;
        Entity entity;
        if (this.suspendTimer > 0) {
            --this.suspendTimer;
        }
        if (this.getCaster() == null && this.casterUUID != null && (entity = EntityUtils.getEntityByUUID(this.field_70170_p, this.casterUUID)) instanceof EntityLivingBase) {
            this.caster = new WeakReference<EntityLivingBase>((EntityLivingBase)entity);
        }
        if (this.func_175131_l() != null) {
            Block block = this.func_175131_l().func_177230_c();
            if (this.func_175131_l().func_185904_a() == Material.field_151579_a) {
                this.func_70106_y();
            } else {
                this.field_70169_q = this.field_70165_t;
                this.field_70167_r = this.field_70163_u;
                this.field_70166_s = this.field_70161_v;
                if (this.field_145812_b++ == 0) {
                    BlockPos blockpos = new BlockPos((Entity)this);
                    if (this.field_70170_p.func_180495_p(blockpos).func_177230_c() == block) {
                        this.field_70170_p.func_175698_g(blockpos);
                    } else if (!this.field_70170_p.field_72995_K) {
                        this.func_70106_y();
                        return;
                    }
                }
                if (!this.func_189652_ae()) {
                    this.field_70181_x -= (double)0.04f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (!this.field_70170_p.field_72995_K) {
                    RayTraceResult raytraceresult;
                    BlockPos blockpos1 = new BlockPos((Entity)this);
                    boolean isConcrete = this.func_175131_l().func_177230_c() == Blocks.field_192444_dS;
                    boolean isConcreteInWater = isConcrete && this.field_70170_p.func_180495_p(blockpos1).func_185904_a() == Material.field_151586_h;
                    double d0 = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y;
                    if (isConcrete && d0 > 1.0 && (raytraceresult = this.field_70170_p.func_72901_a(new Vec3d(this.field_70169_q, this.field_70167_r, this.field_70166_s), new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), true)) != null && this.field_70170_p.func_180495_p(raytraceresult.func_178782_a()).func_185904_a() == Material.field_151586_h) {
                        blockpos1 = raytraceresult.func_178782_a();
                        isConcreteInWater = true;
                    }
                    if (!this.field_70122_E && !isConcreteInWater) {
                        if (this.field_145812_b > 100 && !this.field_70170_p.field_72995_K && (blockpos1.func_177956_o() < 1 || blockpos1.func_177956_o() > 256) || this.field_145812_b > 600) {
                            this.func_70106_y();
                        }
                    } else {
                        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos1);
                        if (this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)) && !isConcreteInWater && BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)))) {
                            this.field_70122_E = false;
                            return;
                        }
                        this.field_70159_w *= (double)0.7f;
                        this.field_70179_y *= (double)0.7f;
                        this.field_70181_x *= -0.5;
                        if (iblockstate.func_177230_c() != Blocks.field_180384_M && this.suspendTimer == 0) {
                            this.func_70106_y();
                            if (this.field_70170_p.func_190527_a(block, blockpos1, true, EnumFacing.UP, null) && (isConcreteInWater || !BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(blockpos1.func_177977_b()))) && this.field_70170_p.func_180501_a(blockpos1, this.func_175131_l(), 3)) {
                                TileEntity tileentity;
                                if (block instanceof BlockFalling) {
                                    ((BlockFalling)block).func_176502_a_(this.field_70170_p, blockpos1, this.func_175131_l(), iblockstate);
                                }
                                if (this.field_145810_d != null && block.hasTileEntity(this.func_175131_l()) && (tileentity = this.field_70170_p.func_175625_s(blockpos1)) != null) {
                                    NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                                    for (String s : this.field_145810_d.func_150296_c()) {
                                        NBTBase nbtbase = this.field_145810_d.func_74781_a(s);
                                        if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                        NBTExtras.storeTagSafely(nbttagcompound, s, nbtbase.func_74737_b());
                                    }
                                    tileentity.func_145839_a(nbttagcompound);
                                    tileentity.func_70296_d();
                                }
                            } else {
                                this.field_70170_p.func_175718_b(2001, this.func_180425_c(), Block.func_176210_f((IBlockState)this.func_175131_l()));
                            }
                        }
                    }
                }
                this.field_70159_w *= (double)0.98f;
                this.field_70181_x *= (double)0.98f;
                this.field_70179_y *= (double)0.98f;
            }
        }
        if ((velocitySquared = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) >= 0.2) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
            for (Entity entity2 : list) {
                if (!(entity2 instanceof EntityLivingBase) || !this.isValidTarget(entity2)) continue;
                float damage = Spells.greater_telekinesis.getProperty("damage").floatValue() * this.damageMultiplier;
                damage = (float)((double)damage * Math.min(1.0, velocitySquared / 0.4));
                entity2.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.getCaster(), MagicDamage.DamageType.FORCE), damage);
                double dx = -this.field_70159_w;
                double dz = -this.field_70179_y;
                while (dx * dx + dz * dz < 1.0E-4) {
                    dx = (Math.random() - Math.random()) * 0.01;
                    dz = (Math.random() - Math.random()) * 0.01;
                }
                ((EntityLivingBase)entity2).func_70653_a((Entity)this, 0.6f, dx, dz);
            }
        }
    }

    public EntityLivingBase getCaster() {
        return this.caster == null ? null : (EntityLivingBase)this.caster.get();
    }

    public void setCaster(EntityLivingBase caster) {
        if (this.getCaster() != caster) {
            this.caster = new WeakReference<EntityLivingBase>(caster);
        }
    }

    public boolean isValidTarget(Entity target) {
        return AllyDesignationSystem.isValidTarget((Entity)this.getCaster(), target);
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.casterUUID = nbttagcompound.func_186857_a("casterUUID");
        this.damageMultiplier = nbttagcompound.func_74760_g("damageMultiplier");
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        if (this.getCaster() != null) {
            nbttagcompound.func_186854_a("casterUUID", this.getCaster().func_110124_au());
        }
        nbttagcompound.func_74776_a("damageMultiplier", this.damageMultiplier);
    }

    public void readSpawnData(ByteBuf buf) {
        if (buf.isReadable()) {
            Block block = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
            try {
                fallTile.set((Object)this, block.func_176203_a(buf.readInt()));
            }
            catch (IllegalAccessException e) {
                Wizardry.logger.error("Error reading levitating block data from packet: ", (Throwable)e);
            }
        }
    }

    public void writeSpawnData(ByteBuf buf) {
        if (this.func_175131_l() != null) {
            buf.writeInt(Block.field_149771_c.func_148757_b((Object)this.func_175131_l().func_177230_c()));
            buf.writeInt(this.func_175131_l().func_177230_c().func_176201_c(this.func_175131_l()));
        }
    }

    static {
        fallTile.setAccessible(true);
    }
}

