/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import com.google.common.collect.Streams;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardryRecipes;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentMending;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemWizardArmour
extends ItemArmor
implements IWorkbenchItem,
IManaStoringItem {
    private static final float SAGE_OTHER_COST_REDUCTION = 0.2f;
    private static final float WARLOCK_SPEED_BOOST = 0.2f;
    private static final UUID WARLOCK_SPEED_BOOST_UUID = UUID.fromString("4bad7152-2663-4b1b-bb59-552e92847031");
    public Element element;
    public final ArmourClass armourClass;

    @Deprecated
    public ItemWizardArmour(ItemArmor.ArmorMaterial material, int renderIndex, EntityEquipmentSlot armourType, Element element) {
        super(material, renderIndex, armourType);
        this.armourClass = ArmourClass.WIZARD;
        this.element = element;
        this.func_77637_a(WizardryTabs.GEAR);
        WizardryRecipes.addToManaFlaskCharging((Item)this);
    }

    public ItemWizardArmour(ArmourClass armourClass, EntityEquipmentSlot armourType, Element element) {
        super(armourClass.material, 1, armourType);
        this.armourClass = armourClass;
        this.element = element;
        this.func_77637_a(WizardryTabs.GEAR);
        WizardryRecipes.addToManaFlaskCharging((Item)this);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (stack.func_77952_i() < damage) {
            super.setDamage(stack, Math.min(damage, stack.func_77958_k()));
        }
    }

    @Override
    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    @Override
    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    @Override
    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return DrawingUtils.mix(16747518, 9318116, (float)this.getDurabilityForDisplay(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (this.element != null) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:wizard_armour.element_cost_reduction", new Style().func_150238_a(TextFormatting.DARK_GRAY), new Object[]{(int)(this.armourClass.elementalCostReduction * 100.0f), this.element.getDisplayName()}));
        }
        if (this.armourClass == ArmourClass.SAGE) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:wizard_armour.enchantability", new Style().func_150238_a(TextFormatting.BLUE), new Object[0]));
        }
        if (this.armourClass.cooldownReduction > 0.0f) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:wizard_armour.cooldown_reduction", new Style().func_150238_a(TextFormatting.DARK_GRAY), new Object[]{(int)(this.armourClass.cooldownReduction * 100.0f)}));
        }
        if (this.armourClass != ArmourClass.WIZARD) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:wizard_armour.full_set", new Style().func_150238_a(TextFormatting.AQUA), new Object[0]));
            Object args = new Object[]{};
            if (this.armourClass == ArmourClass.SAGE) {
                args = 20;
            }
            if (this.armourClass == ArmourClass.WARLOCK) {
                args = 20;
            }
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:" + this.armourClass.name + "_armour.full_set_bonus", new Style().func_150238_a(TextFormatting.AQUA), args));
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD && ItemWizardArmour.isWearingFullSet((EntityLivingBase)player, this.element, ArmourClass.BATTLEMAGE) && player.field_70173_aa % 20 == 0) {
            player.func_70690_d(new PotionEffect(WizardryPotions.ward, 219, 0, true, false));
        }
    }

    protected void applySpellModifiers(EntityLivingBase caster, Spell spell, SpellModifiers modifiers) {
        if (spell.getElement() == this.element) {
            modifiers.set("cost", modifiers.get("cost") - this.armourClass.elementalCostReduction, false);
        }
        modifiers.set(WizardryItems.cooldown_upgrade, modifiers.get(WizardryItems.cooldown_upgrade) - this.armourClass.cooldownReduction, true);
        if (this.field_77881_a == EntityEquipmentSlot.HEAD && ItemWizardArmour.isWearingFullSet(caster, this.element, this.armourClass) && this.armourClass == ArmourClass.SAGE && spell.getElement() != this.element) {
            modifiers.set("cost", 0.8f, false);
        }
    }

    public String func_77653_i(ItemStack stack) {
        return (this.element == null ? "" : this.element.getFormattingCode()) + super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armourSlot, ModelBiped original) {
        if (armourSlot == EntityEquipmentSlot.LEGS && !entityLiving.func_82150_aj()) {
            return null;
        }
        return Wizardry.proxy.getWizardArmourModel(this.func_82812_d());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String s = this.armourClass.name + "_armour";
        if (Wizardry.tisTheSeason && this.armourClass == ArmourClass.WIZARD) {
            s = s + "_festive";
        } else if (this.element != null) {
            s = s + "_" + this.element.func_176610_l();
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            s = s + "_legs";
        }
        return "ebwizardry:textures/armour/" + s + ".png";
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return !(enchantment instanceof EnchantmentMending) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    @Override
    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    @Override
    public ItemStack applyUpgrade(@Nullable EntityPlayer player, ItemStack stack, ItemStack upgrade) {
        if (this.armourClass == ArmourClass.WIZARD) {
            for (ArmourClass armourClass : ArmourClass.values()) {
                if (upgrade.func_77973_b() != armourClass.upgradeItem.get()) continue;
                Item newArmour = ItemWizardArmour.getArmour(this.element, armourClass, this.func_185083_B_());
                ItemStack newStack = new ItemStack(newArmour);
                ((ItemWizardArmour)newArmour).setMana(newStack, this.getMana(stack));
                newStack.func_77982_d(stack.func_77978_p());
                upgrade.func_190918_g(1);
                return newStack;
            }
        }
        return stack;
    }

    @Override
    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (upgrade.func_75216_d()) {
            ItemStack original = centre.func_75211_c().func_77946_l();
            centre.func_75215_d(this.applyUpgrade(player, centre.func_75211_c(), upgrade.func_75211_c()));
            boolean bl = changed = !ItemStack.func_77989_b((ItemStack)centre.func_75211_c(), (ItemStack)original);
        }
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            int manaPerItem = 100;
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                manaPerItem = 10;
            }
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                manaPerItem = 400;
            }
            if (crystals.func_75211_c().func_190916_E() * manaPerItem < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * 100);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / 100.0));
            }
            changed = true;
        }
        return changed;
    }

    @SubscribeEvent
    public static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        IAttributeInstance movementSpeed = event.getEntityLiving().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        if (ItemWizardArmour.isWearingFullSet(event.getEntityLiving(), null, ArmourClass.WARLOCK)) {
            if (movementSpeed.func_111127_a(WARLOCK_SPEED_BOOST_UUID) == null) {
                movementSpeed.func_111121_a(new AttributeModifier(WARLOCK_SPEED_BOOST_UUID, "Warlock set bonus", (double)0.2f, 1));
            }
        } else {
            movementSpeed.func_188479_b(WARLOCK_SPEED_BOOST_UUID);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() == null) {
            return;
        }
        SpellModifiers armourModifiers = new SpellModifiers();
        Arrays.stream(InventoryUtils.ARMOUR_SLOTS).map(s -> event.getCaster().func_184582_a(s).func_77973_b()).filter(i -> i instanceof ItemWizardArmour).forEach(i -> ((ItemWizardArmour)i).applySpellModifiers(event.getCaster(), event.getSpell(), armourModifiers));
        event.getModifiers().combine(armourModifiers);
    }

    @Deprecated
    public static int getMatchingArmourCount(EntityLivingBase entity, Element element) {
        return (int)Arrays.stream(InventoryUtils.ARMOUR_SLOTS).map(s -> entity.func_184582_a(s).func_77973_b()).filter(i -> i instanceof ItemWizardArmour && ((ItemWizardArmour)i).element == element).count();
    }

    public static Item getArmour(Element element, ArmourClass armourClass, EntityEquipmentSlot slot) {
        if (slot == null || slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) {
            throw new IllegalArgumentException("Must be a valid armour slot");
        }
        if (element == null) {
            element = Element.MAGIC;
        }
        String registryName = armourClass.name + "_" + armourClass.armourPieceNames.get(slot);
        if (element != Element.MAGIC) {
            registryName = registryName + "_" + element.func_176610_l();
        }
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ebwizardry", registryName));
    }

    private static boolean isWearingFullSet(EntityLivingBase entity, @Nullable Element element, @Nullable ArmourClass armourClass) {
        ItemStack helmet = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        if (!(helmet.func_77973_b() instanceof ItemWizardArmour)) {
            return false;
        }
        Element e = element == null ? ((ItemWizardArmour)helmet.func_77973_b()).element : element;
        ArmourClass ac = armourClass == null ? ((ItemWizardArmour)helmet.func_77973_b()).armourClass : armourClass;
        return Arrays.stream(InventoryUtils.ARMOUR_SLOTS).allMatch(s -> entity.func_184582_a(s).func_77973_b() instanceof ItemWizardArmour && ((ItemWizardArmour)entity.func_184582_a((EntityEquipmentSlot)s).func_77973_b()).element == e && ((ItemWizardArmour)entity.func_184582_a((EntityEquipmentSlot)s).func_77973_b()).armourClass == ac);
    }

    @SubscribeEvent
    public static void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityLiving && event.getEntityLiving().func_82150_aj()) {
            float f;
            double followRange;
            int armourPieces = (int)Streams.stream((Iterable)event.getTarget().func_184193_aE()).filter(s -> !s.func_190926_b() && !(s.func_77973_b() instanceof ItemWizardArmour)).count();
            if (armourPieces == 0) {
                return;
            }
            IAttributeInstance attribute = event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111265_b);
            double d = followRange = attribute == null ? 16.0 : attribute.func_111126_e();
            if (event.getTarget().func_70093_af()) {
                followRange *= 0.8;
            }
            if ((f = (float)armourPieces / (float)((EntityPlayer)event.getTarget()).field_71071_by.field_70460_b.size()) < 0.1f) {
                f = 0.1f;
            }
            followRange *= (double)(0.7f * f);
            if ((double)event.getTarget().func_70032_d(event.getEntity()) > followRange) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }

    public static enum ArmourClass {
        WIZARD(WizardryItems.Materials.SILK, () -> null, "wizard", 0.1f, 0.0f, "hat", "robe", "leggings", "boots"),
        SAGE(WizardryItems.Materials.SAGE, () -> WizardryItems.resplendent_thread, "sage", 0.2f, 0.0f, "hat", "robe", "leggings", "boots"),
        BATTLEMAGE(WizardryItems.Materials.BATTLEMAGE, () -> WizardryItems.crystal_silver_plating, "battlemage", 0.05f, 0.15f, "helmet", "chestplate", "leggings", "boots"),
        WARLOCK(WizardryItems.Materials.WARLOCK, () -> WizardryItems.ethereal_crystalweave, "warlock", 0.1f, 0.3f, "hood", "robe", "leggings", "boots");

        final ItemArmor.ArmorMaterial material;
        final Supplier<Item> upgradeItem;
        final float elementalCostReduction;
        final float cooldownReduction;
        final String name;
        final Map<EntityEquipmentSlot, String> armourPieceNames;

        private ArmourClass(ItemArmor.ArmorMaterial material, Supplier<Item> upgradeItem, String name, float elementalCostReduction, float cooldownReduction, String ... armourPieceNames) {
            this.material = material;
            this.upgradeItem = upgradeItem;
            this.name = name;
            this.elementalCostReduction = elementalCostReduction;
            this.cooldownReduction = cooldownReduction;
            if (armourPieceNames.length != 4) {
                throw new IllegalArgumentException("armourPieceNames must have a length of 4");
            }
            this.armourPieceNames = new EnumMap<EntityEquipmentSlot, String>(EntityEquipmentSlot.class);
            this.armourPieceNames.put(EntityEquipmentSlot.HEAD, armourPieceNames[0]);
            this.armourPieceNames.put(EntityEquipmentSlot.CHEST, armourPieceNames[1]);
            this.armourPieceNames.put(EntityEquipmentSlot.LEGS, armourPieceNames[2]);
            this.armourPieceNames.put(EntityEquipmentSlot.FEET, armourPieceNames[3]);
        }
    }
}

